/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.util.Map;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.property.access.internal.PropertyAccessStrategyBackRefImpl;
import org.hibernate.tuple.NonIdentifierAttribute;
import org.hibernate.type.CompositeType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;

public class TypeHelper {
    private TypeHelper() {
    }

    public static void deepCopy(Object[] values2, Type[] types, boolean[] copy, Object[] target, SessionImplementor session) {
        for (int i = 0; i < types.length; ++i) {
            if (!copy[i]) continue;
            target[i] = values2[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || values2[i] == PropertyAccessStrategyBackRefImpl.UNKNOWN ? values2[i] : types[i].deepCopy(values2[i], session.getFactory());
        }
    }

    public static void beforeAssemble(Serializable[] row, Type[] types, SessionImplementor session) {
        for (int i = 0; i < types.length; ++i) {
            if (row[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || row[i] == PropertyAccessStrategyBackRefImpl.UNKNOWN) continue;
            types[i].beforeAssemble(row[i], session);
        }
    }

    public static Object[] assemble(Serializable[] row, Type[] types, SessionImplementor session, Object owner) {
        Object[] assembled = new Object[row.length];
        for (int i = 0; i < types.length; ++i) {
            assembled[i] = row[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || row[i] == PropertyAccessStrategyBackRefImpl.UNKNOWN ? row[i] : types[i].assemble(row[i], session, owner);
        }
        return assembled;
    }

    public static Serializable[] disassemble(Object[] row, Type[] types, boolean[] nonCacheable, SessionImplementor session, Object owner) {
        Serializable[] disassembled = new Serializable[row.length];
        for (int i = 0; i < row.length; ++i) {
            disassembled[i] = nonCacheable != null && nonCacheable[i] ? LazyPropertyInitializer.UNFETCHED_PROPERTY : (row[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || row[i] == PropertyAccessStrategyBackRefImpl.UNKNOWN ? (Serializable)row[i] : types[i].disassemble(row[i], session, owner));
        }
        return disassembled;
    }

    public static Object[] replace(Object[] original, Object[] target, Type[] types, SessionImplementor session, Object owner, Map copyCache) {
        Object[] copied = new Object[original.length];
        for (int i = 0; i < types.length; ++i) {
            if (original[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || original[i] == PropertyAccessStrategyBackRefImpl.UNKNOWN) {
                copied[i] = target[i];
                continue;
            }
            if (target[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
                if (types[i].isMutable()) {
                    copied[i] = types[i].deepCopy(original[i], session.getFactory());
                    continue;
                }
                copied[i] = original[i];
                continue;
            }
            copied[i] = types[i].replace(original[i], target[i], session, owner, copyCache);
        }
        return copied;
    }

    public static Object[] replace(Object[] original, Object[] target, Type[] types, SessionImplementor session, Object owner, Map copyCache, ForeignKeyDirection foreignKeyDirection) {
        Object[] copied = new Object[original.length];
        for (int i = 0; i < types.length; ++i) {
            copied[i] = original[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || original[i] == PropertyAccessStrategyBackRefImpl.UNKNOWN ? target[i] : types[i].replace(original[i], target[i], session, owner, copyCache, foreignKeyDirection);
        }
        return copied;
    }

    public static Object[] replaceAssociations(Object[] original, Object[] target, Type[] types, SessionImplementor session, Object owner, Map copyCache, ForeignKeyDirection foreignKeyDirection) {
        Object[] copied = new Object[original.length];
        for (int i = 0; i < types.length; ++i) {
            if (original[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY || original[i] == PropertyAccessStrategyBackRefImpl.UNKNOWN) {
                copied[i] = target[i];
                continue;
            }
            if (types[i].isComponentType()) {
                CompositeType componentType = (CompositeType)types[i];
                Type[] subtypes = componentType.getSubtypes();
                Object[] origComponentValues = original[i] == null ? new Object[subtypes.length] : componentType.getPropertyValues(original[i], session);
                Object[] targetComponentValues = target[i] == null ? new Object[subtypes.length] : componentType.getPropertyValues(target[i], session);
                TypeHelper.replaceAssociations(origComponentValues, targetComponentValues, subtypes, session, null, copyCache, foreignKeyDirection);
                copied[i] = target[i];
                continue;
            }
            copied[i] = !types[i].isAssociationType() ? target[i] : types[i].replace(original[i], target[i], session, owner, copyCache, foreignKeyDirection);
        }
        return copied;
    }

    public static int[] findDirty(NonIdentifierAttribute[] properties, Object[] currentState, Object[] previousState, boolean[][] includeColumns, boolean anyUninitializedProperties, SessionImplementor session) {
        int[] results = null;
        int count2 = 0;
        int span = properties.length;
        for (int i = 0; i < span; ++i) {
            boolean dirty;
            boolean bl = dirty = currentState[i] != LazyPropertyInitializer.UNFETCHED_PROPERTY && properties[i].isDirtyCheckable(anyUninitializedProperties) && properties[i].getType().isDirty(previousState[i], currentState[i], includeColumns[i], session);
            if (!dirty) continue;
            if (results == null) {
                results = new int[span];
            }
            results[count2++] = i;
        }
        if (count2 == 0) {
            return null;
        }
        int[] trimmed = new int[count2];
        System.arraycopy(results, 0, trimmed, 0, count2);
        return trimmed;
    }

    public static int[] findModified(NonIdentifierAttribute[] properties, Object[] currentState, Object[] previousState, boolean[][] includeColumns, boolean anyUninitializedProperties, SessionImplementor session) {
        int[] results = null;
        int count2 = 0;
        int span = properties.length;
        for (int i = 0; i < span; ++i) {
            boolean modified;
            boolean bl = modified = currentState[i] != LazyPropertyInitializer.UNFETCHED_PROPERTY && properties[i].isDirtyCheckable(anyUninitializedProperties) && properties[i].getType().isModified(previousState[i], currentState[i], includeColumns[i], session);
            if (!modified) continue;
            if (results == null) {
                results = new int[span];
            }
            results[count2++] = i;
        }
        if (count2 == 0) {
            return null;
        }
        int[] trimmed = new int[count2];
        System.arraycopy(results, 0, trimmed, 0, count2);
        return trimmed;
    }
}

