/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core;

import java.io.Serializable;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;

public class StepContribution
implements Serializable {
    private volatile int readCount = 0;
    private volatile int writeCount = 0;
    private volatile int filterCount = 0;
    private final int parentSkipCount;
    private volatile int readSkipCount;
    private volatile int writeSkipCount;
    private volatile int processSkipCount;
    private ExitStatus exitStatus = ExitStatus.EXECUTING;

    public StepContribution(StepExecution execution) {
        this.parentSkipCount = execution.getSkipCount();
    }

    public void setExitStatus(ExitStatus status) {
        this.exitStatus = status;
    }

    public ExitStatus getExitStatus() {
        return this.exitStatus;
    }

    public void incrementFilterCount(int count2) {
        this.filterCount += count2;
    }

    public void incrementReadCount() {
        ++this.readCount;
    }

    public void incrementWriteCount(int count2) {
        this.writeCount += count2;
    }

    public int getReadCount() {
        return this.readCount;
    }

    public int getWriteCount() {
        return this.writeCount;
    }

    public int getFilterCount() {
        return this.filterCount;
    }

    public int getStepSkipCount() {
        return this.readSkipCount + this.writeSkipCount + this.processSkipCount + this.parentSkipCount;
    }

    public int getSkipCount() {
        return this.readSkipCount + this.writeSkipCount + this.processSkipCount;
    }

    public void incrementReadSkipCount() {
        ++this.readSkipCount;
    }

    public void incrementReadSkipCount(int count2) {
        this.readSkipCount += count2;
    }

    public void incrementWriteSkipCount() {
        ++this.writeSkipCount;
    }

    public void incrementProcessSkipCount() {
        ++this.processSkipCount;
    }

    public int getReadSkipCount() {
        return this.readSkipCount;
    }

    public int getWriteSkipCount() {
        return this.writeSkipCount;
    }

    public int getProcessSkipCount() {
        return this.processSkipCount;
    }

    public String toString() {
        return "[StepContribution: read=" + this.readCount + ", written=" + this.writeCount + ", filtered=" + this.filterCount + ", readSkips=" + this.readSkipCount + ", writeSkips=" + this.writeSkipCount + ", processSkips=" + this.processSkipCount + ", exitStatus=" + this.exitStatus.getExitCode() + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StepContribution)) {
            return false;
        }
        StepContribution other = (StepContribution)obj;
        return this.toString().equals(other.toString());
    }

    public int hashCode() {
        return 11 + this.toString().hashCode() * 43;
    }
}

