/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.annotation;

import java.util.Collection;
import javax.sql.DataSource;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.configuration.annotation.BatchConfigurer;
import org.springframework.batch.core.configuration.annotation.DefaultBatchConfigurer;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.ScopeConfiguration;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.configuration.support.MapJobRegistry;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;

@Configuration
@Import(value={ScopeConfiguration.class})
public abstract class AbstractBatchConfiguration
implements ImportAware {
    @Autowired(required=false)
    private Collection<DataSource> dataSources;
    private BatchConfigurer configurer;

    @Bean
    public JobBuilderFactory jobBuilders() throws Exception {
        return new JobBuilderFactory(this.jobRepository());
    }

    @Bean
    public StepBuilderFactory stepBuilders() throws Exception {
        return new StepBuilderFactory(this.jobRepository(), this.transactionManager());
    }

    @Bean
    public abstract JobRepository jobRepository() throws Exception;

    @Bean
    public abstract JobLauncher jobLauncher() throws Exception;

    @Bean
    public abstract JobExplorer jobExplorer() throws Exception;

    @Bean
    public JobRegistry jobRegistry() throws Exception {
        return new MapJobRegistry();
    }

    @Bean
    public abstract PlatformTransactionManager transactionManager() throws Exception;

    @Override
    public void setImportMetadata(AnnotationMetadata importMetadata) {
        AnnotationAttributes enabled = AnnotationAttributes.fromMap(importMetadata.getAnnotationAttributes(EnableBatchProcessing.class.getName(), false));
        Assert.notNull(enabled, "@EnableBatchProcessing is not present on importing class " + importMetadata.getClassName());
    }

    protected BatchConfigurer getConfigurer(Collection<BatchConfigurer> configurers) throws Exception {
        if (this.configurer != null) {
            return this.configurer;
        }
        if (configurers == null || configurers.isEmpty()) {
            if (this.dataSources == null || this.dataSources.isEmpty()) {
                DefaultBatchConfigurer configurer = new DefaultBatchConfigurer();
                configurer.initialize();
                this.configurer = configurer;
                return configurer;
            }
            if (this.dataSources != null && this.dataSources.size() == 1) {
                DataSource dataSource = this.dataSources.iterator().next();
                DefaultBatchConfigurer configurer = new DefaultBatchConfigurer(dataSource);
                configurer.initialize();
                this.configurer = configurer;
                return configurer;
            }
            throw new IllegalStateException("To use the default BatchConfigurer the context must contain no more thanone DataSource, found " + this.dataSources.size());
        }
        if (configurers.size() > 1) {
            throw new IllegalStateException("To use a custom BatchConfigurer the context must contain precisely one, found " + configurers.size());
        }
        this.configurer = configurers.iterator().next();
        return this.configurer;
    }
}

