/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.converter;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.util.StringUtils;

public class DefaultJobParametersConverter
implements JobParametersConverter {
    public static final String DATE_TYPE = "(date)";
    public static final String STRING_TYPE = "(string)";
    public static final String LONG_TYPE = "(long)";
    private static final String DOUBLE_TYPE = "(double)";
    private static final String NON_IDENTIFYING_FLAG = "-";
    private static final String IDENTIFYING_FLAG = "+";
    private static NumberFormat DEFAULT_NUMBER_FORMAT = NumberFormat.getInstance(Locale.US);
    private DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
    private NumberFormat numberFormat = DEFAULT_NUMBER_FORMAT;
    private final NumberFormat longNumberFormat = new DecimalFormat("#");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobParameters getJobParameters(Properties props) {
        if (props == null || props.isEmpty()) {
            return new JobParameters();
        }
        JobParametersBuilder propertiesBuilder = new JobParametersBuilder();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            Number result;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            boolean identifying = this.isIdentifyingKey(key);
            if (!identifying) {
                key = key.replaceFirst(NON_IDENTIFYING_FLAG, "");
            } else if (identifying && key.startsWith(IDENTIFYING_FLAG)) {
                key = key.replaceFirst("\\+", "");
            }
            if (key.endsWith(DATE_TYPE)) {
                Date date;
                DateFormat dateFormat = this.dateFormat;
                synchronized (dateFormat) {
                    try {
                        date = this.dateFormat.parse(value);
                    }
                    catch (ParseException ex) {
                        String suffix = this.dateFormat instanceof SimpleDateFormat ? ", use " + ((SimpleDateFormat)this.dateFormat).toPattern() : "";
                        throw new IllegalArgumentException("Date format is invalid: [" + value + "]" + suffix);
                    }
                }
                propertiesBuilder.addDate(StringUtils.replace(key, DATE_TYPE, ""), date, identifying);
                continue;
            }
            if (key.endsWith(LONG_TYPE)) {
                try {
                    result = (Long)this.parseNumber(value);
                }
                catch (ClassCastException ex) {
                    throw new IllegalArgumentException("Number format is invalid for long value: [" + value + "], use a format with no decimal places");
                }
                propertiesBuilder.addLong(StringUtils.replace(key, LONG_TYPE, ""), (Long)result, identifying);
                continue;
            }
            if (key.endsWith(DOUBLE_TYPE)) {
                result = this.parseNumber(value).doubleValue();
                propertiesBuilder.addDouble(StringUtils.replace(key, DOUBLE_TYPE, ""), (Double)result, identifying);
                continue;
            }
            if (StringUtils.endsWithIgnoreCase(key, STRING_TYPE)) {
                propertiesBuilder.addString(StringUtils.replace(key, STRING_TYPE, ""), value, identifying);
                continue;
            }
            propertiesBuilder.addString(key, value, identifying);
        }
        return propertiesBuilder.toJobParameters();
    }

    private boolean isIdentifyingKey(String key) {
        boolean identifying = true;
        if (key.startsWith(NON_IDENTIFYING_FLAG)) {
            identifying = false;
        }
        return identifying;
    }

    private Number parseNumber(String value) {
        NumberFormat numberFormat = this.numberFormat;
        synchronized (numberFormat) {
            try {
                return this.numberFormat.parse(value);
            }
            catch (ParseException ex) {
                String suffix = this.numberFormat instanceof DecimalFormat ? ", use " + ((DecimalFormat)this.numberFormat).toPattern() : "";
                throw new IllegalArgumentException("Number format is invalid: [" + value + "], use " + suffix);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getProperties(JobParameters params) {
        if (params == null || params.isEmpty()) {
            return new Properties();
        }
        Map<String, JobParameter> parameters = params.getParameters();
        Properties result = new Properties();
        for (Map.Entry<String, JobParameter> entry : parameters.entrySet()) {
            Format format;
            String key = entry.getKey();
            JobParameter jobParameter = entry.getValue();
            Object value = jobParameter.getValue();
            if (value == null) continue;
            key = (!jobParameter.isIdentifying() ? NON_IDENTIFYING_FLAG : "") + key;
            if (jobParameter.getType() == JobParameter.ParameterType.DATE) {
                format = this.dateFormat;
                synchronized (format) {
                    result.setProperty(key + DATE_TYPE, this.dateFormat.format(value));
                    continue;
                }
            }
            if (jobParameter.getType() == JobParameter.ParameterType.LONG) {
                format = this.longNumberFormat;
                synchronized (format) {
                    result.setProperty(key + LONG_TYPE, this.longNumberFormat.format(value));
                    continue;
                }
            }
            if (jobParameter.getType() == JobParameter.ParameterType.DOUBLE) {
                result.setProperty(key + DOUBLE_TYPE, this.decimalFormat((Double)value));
                continue;
            }
            result.setProperty(key, "" + value);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String decimalFormat(double value) {
        if (this.numberFormat != DEFAULT_NUMBER_FORMAT) {
            NumberFormat numberFormat = this.numberFormat;
            synchronized (numberFormat) {
                return this.numberFormat.format(value);
            }
        }
        return Double.toString(value);
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }
}

