/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr;

import java.util.Properties;
import javax.batch.runtime.context.StepContext;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.jsr.JsrStepContext;
import org.springframework.batch.core.jsr.configuration.support.BatchPropertyContext;
import org.springframework.batch.core.scope.context.StepSynchronizationManager;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.FactoryBeanNotInitializedException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class JsrStepContextFactoryBean
implements FactoryBean<StepContext>,
InitializingBean {
    @Autowired
    private BatchPropertyContext batchPropertyContext;
    private static final ThreadLocal<StepContext> contextHolder = new ThreadLocal();

    protected void setBatchPropertyContext(BatchPropertyContext batchPropertyContext) {
        this.batchPropertyContext = batchPropertyContext;
    }

    @Override
    public StepContext getObject() throws Exception {
        return this.getCurrent();
    }

    private StepContext getCurrent() {
        StepExecution curStepExecution = null;
        if (StepSynchronizationManager.getContext() != null) {
            curStepExecution = StepSynchronizationManager.getContext().getStepExecution();
        }
        if (curStepExecution == null) {
            throw new FactoryBeanNotInitializedException("A StepExecution is required");
        }
        StepContext context = contextHolder.get();
        if (context != null && context.getStepExecutionId() == curStepExecution.getId().longValue()) {
            return context;
        }
        Properties stepProperties = this.batchPropertyContext.getStepProperties(curStepExecution.getStepName());
        context = stepProperties != null ? new JsrStepContext(curStepExecution, stepProperties) : new JsrStepContext(curStepExecution, new Properties());
        contextHolder.set(context);
        return context;
    }

    @Override
    public Class<?> getObjectType() {
        return StepContext.class;
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.batchPropertyContext, "BatchPropertyContext is required");
    }

    public void remove() {
        if (contextHolder.get() != null) {
            contextHolder.remove();
        }
    }
}

