/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.List;
import javax.batch.api.chunk.listener.RetryProcessListener;
import javax.batch.api.chunk.listener.RetryReadListener;
import javax.batch.api.chunk.listener.RetryWriteListener;
import javax.batch.operations.BatchRuntimeException;
import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.ItemProcessListener;
import org.springframework.batch.core.ItemReadListener;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.SkipListener;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.listener.CompositeChunkListener;
import org.springframework.batch.core.listener.CompositeItemProcessListener;
import org.springframework.batch.core.listener.CompositeItemReadListener;
import org.springframework.batch.core.listener.CompositeItemWriteListener;
import org.springframework.batch.core.listener.CompositeRetryProcessListener;
import org.springframework.batch.core.listener.CompositeRetryReadListener;
import org.springframework.batch.core.listener.CompositeRetryWriteListener;
import org.springframework.batch.core.listener.CompositeSkipListener;
import org.springframework.batch.core.listener.CompositeStepExecutionListener;
import org.springframework.batch.core.listener.StepListenerFailedException;
import org.springframework.batch.core.scope.context.ChunkContext;

public class MulticasterBatchListener<T, S>
implements StepExecutionListener,
ChunkListener,
ItemReadListener<T>,
ItemProcessListener<T, S>,
ItemWriteListener<S>,
SkipListener<T, S>,
RetryReadListener,
RetryProcessListener,
RetryWriteListener {
    private CompositeStepExecutionListener stepListener = new CompositeStepExecutionListener();
    private CompositeChunkListener chunkListener = new CompositeChunkListener();
    private CompositeItemReadListener<T> itemReadListener = new CompositeItemReadListener();
    private CompositeItemProcessListener<T, S> itemProcessListener = new CompositeItemProcessListener();
    private CompositeItemWriteListener<S> itemWriteListener = new CompositeItemWriteListener();
    private CompositeSkipListener<T, S> skipListener = new CompositeSkipListener();
    private CompositeRetryReadListener retryReadListener = new CompositeRetryReadListener();
    private CompositeRetryProcessListener retryProcessListener = new CompositeRetryProcessListener();
    private CompositeRetryWriteListener retryWriteListener = new CompositeRetryWriteListener();

    public void setListeners(List<? extends StepListener> listeners) {
        for (StepListener stepListener : listeners) {
            this.register(stepListener);
        }
    }

    public void register(StepListener listener2) {
        if (listener2 instanceof StepExecutionListener) {
            this.stepListener.register((StepExecutionListener)listener2);
        }
        if (listener2 instanceof ChunkListener) {
            this.chunkListener.register((ChunkListener)listener2);
        }
        if (listener2 instanceof ItemReadListener) {
            ItemReadListener itemReadListener = (ItemReadListener)listener2;
            this.itemReadListener.register(itemReadListener);
        }
        if (listener2 instanceof ItemProcessListener) {
            ItemProcessListener itemProcessListener = (ItemProcessListener)listener2;
            this.itemProcessListener.register(itemProcessListener);
        }
        if (listener2 instanceof ItemWriteListener) {
            ItemWriteListener itemWriteListener = (ItemWriteListener)listener2;
            this.itemWriteListener.register(itemWriteListener);
        }
        if (listener2 instanceof SkipListener) {
            SkipListener skipListener = (SkipListener)listener2;
            this.skipListener.register(skipListener);
        }
        if (listener2 instanceof RetryReadListener) {
            this.retryReadListener.register((RetryReadListener)((Object)listener2));
        }
        if (listener2 instanceof RetryProcessListener) {
            this.retryProcessListener.register((RetryProcessListener)((Object)listener2));
        }
        if (listener2 instanceof RetryWriteListener) {
            this.retryWriteListener.register((RetryWriteListener)((Object)listener2));
        }
    }

    @Override
    public void afterProcess(T item, S result) {
        try {
            this.itemProcessListener.afterProcess(item, result);
        }
        catch (RuntimeException e) {
            throw new StepListenerFailedException("Error in afterProcess.", e);
        }
    }

    @Override
    public void beforeProcess(T item) {
        try {
            this.itemProcessListener.beforeProcess(item);
        }
        catch (RuntimeException e) {
            throw new StepListenerFailedException("Error in beforeProcess.", e);
        }
    }

    @Override
    public void onProcessError(T item, Exception ex) {
        try {
            this.itemProcessListener.onProcessError(item, ex);
        }
        catch (RuntimeException e) {
            throw new StepListenerFailedException("Error in onProcessError.", e);
        }
    }

    @Override
    public ExitStatus afterStep(StepExecution stepExecution) {
        try {
            return this.stepListener.afterStep(stepExecution);
        }
        catch (RuntimeException e) {
            throw new StepListenerFailedException("Error in afterStep.", e);
        }
    }

    @Override
    public void beforeStep(StepExecution stepExecution) {
        try {
            this.stepListener.beforeStep(stepExecution);
        }
        catch (RuntimeException e) {
            throw new StepListenerFailedException("Error in beforeStep.", e);
        }
    }

    @Override
    public void afterChunk(ChunkContext context) {
        try {
            this.chunkListener.afterChunk(context);
        }
        catch (RuntimeException e) {
            throw new StepListenerFailedException("Error in afterChunk.", e);
        }
    }

    @Override
    public void beforeChunk(ChunkContext context) {
        try {
            this.chunkListener.beforeChunk(context);
        }
        catch (RuntimeException e) {
            throw new StepListenerFailedException("Error in beforeChunk.", e);
        }
    }

    @Override
    public void afterRead(T item) {
        try {
            this.itemReadListener.afterRead(item);
        }
        catch (RuntimeException e) {
            throw new StepListenerFailedException("Error in afterRead.", e);
        }
    }

    @Override
    public void beforeRead() {
        try {
            this.itemReadListener.beforeRead();
        }
        catch (RuntimeException e) {
            throw new StepListenerFailedException("Error in beforeRead.", e);
        }
    }

    @Override
    public void onReadError(Exception ex) {
        try {
            this.itemReadListener.onReadError(ex);
        }
        catch (RuntimeException e) {
            throw new StepListenerFailedException("Error in onReadError.", e);
        }
    }

    @Override
    public void afterWrite(List<? extends S> items) {
        try {
            this.itemWriteListener.afterWrite(items);
        }
        catch (RuntimeException e) {
            throw new StepListenerFailedException("Error in afterWrite.", e);
        }
    }

    @Override
    public void beforeWrite(List<? extends S> items) {
        try {
            this.itemWriteListener.beforeWrite(items);
        }
        catch (RuntimeException e) {
            throw new StepListenerFailedException("Error in beforeWrite.", e);
        }
    }

    @Override
    public void onWriteError(Exception ex, List<? extends S> items) {
        try {
            this.itemWriteListener.onWriteError(ex, items);
        }
        catch (RuntimeException e) {
            throw new StepListenerFailedException("Error in onWriteError.", e);
        }
    }

    @Override
    public void onSkipInRead(Throwable t) {
        this.skipListener.onSkipInRead(t);
    }

    @Override
    public void onSkipInWrite(S item, Throwable t) {
        this.skipListener.onSkipInWrite(item, t);
    }

    @Override
    public void onSkipInProcess(T item, Throwable t) {
        this.skipListener.onSkipInProcess(item, t);
    }

    @Override
    public void afterChunkError(ChunkContext context) {
        try {
            this.chunkListener.afterChunkError(context);
        }
        catch (RuntimeException e) {
            throw new StepListenerFailedException("Error in afterFailedChunk.", e);
        }
    }

    @Override
    public void onRetryReadException(Exception ex) throws Exception {
        try {
            this.retryReadListener.onRetryReadException(ex);
        }
        catch (Exception e) {
            throw new BatchRuntimeException(e);
        }
    }

    @Override
    public void onRetryProcessException(Object item, Exception ex) throws Exception {
        try {
            this.retryProcessListener.onRetryProcessException(item, ex);
        }
        catch (Exception e) {
            throw new BatchRuntimeException(e);
        }
    }

    @Override
    public void onRetryWriteException(List<Object> items, Exception ex) throws Exception {
        try {
            this.retryWriteListener.onRetryWriteException(items, ex);
        }
        catch (Exception e) {
            throw new BatchRuntimeException(e);
        }
    }
}

