/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.partition.support;

import java.util.Collection;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.partition.PartitionHandler;
import org.springframework.batch.core.partition.StepExecutionSplitter;
import org.springframework.batch.core.partition.support.DefaultStepExecutionAggregator;
import org.springframework.batch.core.partition.support.StepExecutionAggregator;
import org.springframework.batch.core.step.AbstractStep;
import org.springframework.util.Assert;

public class PartitionStep
extends AbstractStep {
    private StepExecutionSplitter stepExecutionSplitter;
    private PartitionHandler partitionHandler;
    private StepExecutionAggregator stepExecutionAggregator = new DefaultStepExecutionAggregator();

    public void setPartitionHandler(PartitionHandler partitionHandler) {
        this.partitionHandler = partitionHandler;
    }

    public void setStepExecutionAggregator(StepExecutionAggregator stepExecutionAggregator) {
        this.stepExecutionAggregator = stepExecutionAggregator;
    }

    public void setStepExecutionSplitter(StepExecutionSplitter stepExecutionSplitter) {
        this.stepExecutionSplitter = stepExecutionSplitter;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.stepExecutionSplitter, "StepExecutionSplitter must be provided");
        Assert.notNull(this.partitionHandler, "PartitionHandler must be provided");
        super.afterPropertiesSet();
    }

    @Override
    protected void doExecute(StepExecution stepExecution) throws Exception {
        stepExecution.getExecutionContext().put("batch.stepType", this.getClass().getName());
        Collection<StepExecution> executions = this.partitionHandler.handle(this.stepExecutionSplitter, stepExecution);
        stepExecution.upgradeStatus(BatchStatus.COMPLETED);
        this.stepExecutionAggregator.aggregate(stepExecution, executions);
        if (stepExecution.getStatus().isUnsuccessful()) {
            throw new JobExecutionException("Partition handler returned an unsuccessful step");
        }
    }

    protected StepExecutionSplitter getStepExecutionSplitter() {
        return this.stepExecutionSplitter;
    }

    protected PartitionHandler getPartitionHandler() {
        return this.partitionHandler;
    }
}

