/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.step.StepInterruptionPolicy;

public class ThreadStepInterruptionPolicy
implements StepInterruptionPolicy {
    protected static final Log logger = LogFactory.getLog(ThreadStepInterruptionPolicy.class);

    @Override
    public void checkInterrupted(StepExecution stepExecution) throws JobInterruptedException {
        if (this.isInterrupted(stepExecution)) {
            throw new JobInterruptedException("Job interrupted status detected.");
        }
    }

    private boolean isInterrupted(StepExecution stepExecution) {
        boolean interrupted = Thread.currentThread().isInterrupted();
        if (interrupted) {
            logger.info("Step interrupted through Thread API");
        } else {
            interrupted = stepExecution.isTerminateOnly();
            if (interrupted) {
                logger.info("Step interrupted through StepExecution");
            }
        }
        return interrupted;
    }
}

