/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.tasklet;

import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.listener.StepExecutionListenerSupport;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.SimpleSystemProcessExitCodeMapper;
import org.springframework.batch.core.step.tasklet.StoppableTasklet;
import org.springframework.batch.core.step.tasklet.SystemCommandException;
import org.springframework.batch.core.step.tasklet.SystemProcessExitCodeMapper;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.Assert;

public class SystemCommandTasklet
extends StepExecutionListenerSupport
implements StoppableTasklet,
InitializingBean {
    protected static final Log logger = LogFactory.getLog(SystemCommandTasklet.class);
    private String command;
    private String[] environmentParams = null;
    private File workingDirectory = null;
    private SystemProcessExitCodeMapper systemProcessExitCodeMapper = new SimpleSystemProcessExitCodeMapper();
    private long timeout = 0L;
    private long checkInterval = 1000L;
    private StepExecution execution = null;
    private TaskExecutor taskExecutor = new SimpleAsyncTaskExecutor();
    private boolean interruptOnCancel = false;
    private volatile boolean stopped = false;
    private JobExplorer jobExplorer;
    private boolean stoppable = false;

    @Override
    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        FutureTask<Integer> systemCommandTask = new FutureTask<Integer>(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                Process process = Runtime.getRuntime().exec(SystemCommandTasklet.this.command, SystemCommandTasklet.this.environmentParams, SystemCommandTasklet.this.workingDirectory);
                return process.waitFor();
            }
        });
        long t0 = System.currentTimeMillis();
        this.taskExecutor.execute(systemCommandTask);
        do {
            JobExecution jobExecution;
            Thread.sleep(this.checkInterval);
            if (this.stoppable && (jobExecution = this.jobExplorer.getJobExecution(chunkContext.getStepContext().getStepExecution().getJobExecutionId())).isStopping()) {
                this.stopped = true;
            }
            if (systemCommandTask.isDone()) {
                contribution.setExitStatus(this.systemProcessExitCodeMapper.getExitStatus(systemCommandTask.get()));
                return RepeatStatus.FINISHED;
            }
            if (System.currentTimeMillis() - t0 > this.timeout) {
                systemCommandTask.cancel(this.interruptOnCancel);
                throw new SystemCommandException("Execution of system command did not finish within the timeout");
            }
            if (!this.execution.isTerminateOnly()) continue;
            systemCommandTask.cancel(this.interruptOnCancel);
            throw new JobInterruptedException("Job interrupted while executing system command '" + this.command + "'");
        } while (!this.stopped);
        systemCommandTask.cancel(this.interruptOnCancel);
        contribution.setExitStatus(ExitStatus.STOPPED);
        return RepeatStatus.FINISHED;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setEnvironmentParams(String[] envp) {
        this.environmentParams = envp;
    }

    public void setWorkingDirectory(String dir) {
        if (dir == null) {
            this.workingDirectory = null;
            return;
        }
        this.workingDirectory = new File(dir);
        Assert.isTrue(this.workingDirectory.exists(), "working directory must exist");
        Assert.isTrue(this.workingDirectory.isDirectory(), "working directory value must be a directory");
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.hasLength(this.command, "'command' property value is required");
        Assert.notNull(this.systemProcessExitCodeMapper, "SystemProcessExitCodeMapper must be set");
        Assert.isTrue(this.timeout > 0L, "timeout value must be greater than zero");
        Assert.notNull(this.taskExecutor, "taskExecutor is required");
        this.stoppable = this.jobExplorer != null;
    }

    public void setJobExplorer(JobExplorer jobExplorer) {
        this.jobExplorer = jobExplorer;
    }

    public void setSystemProcessExitCodeMapper(SystemProcessExitCodeMapper systemProcessExitCodeMapper) {
        this.systemProcessExitCodeMapper = systemProcessExitCodeMapper;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setTerminationCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }

    @Override
    public void beforeStep(StepExecution stepExecution) {
        this.execution = stepExecution;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setInterruptOnCancel(boolean interruptOnCancel) {
        this.interruptOnCancel = interruptOnCancel;
    }

    @Override
    public void stop() {
        this.stopped = true;
    }
}

