/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.data;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.neo4j.template.Neo4jOperations;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class Neo4jItemWriter<T>
implements ItemWriter<T>,
InitializingBean {
    protected static final Log logger = LogFactory.getLog(Neo4jItemWriter.class);
    private boolean delete = false;
    private Neo4jOperations template;

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public void setTemplate(Neo4jOperations template) {
        this.template = template;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.state(this.template != null, "A Neo4JOperations implementation is required");
    }

    @Override
    public void write(List<? extends T> items) throws Exception {
        if (!CollectionUtils.isEmpty(items)) {
            this.doWrite(items);
        }
    }

    protected void doWrite(List<? extends T> items) {
        if (this.delete) {
            for (T t : items) {
                this.template.delete(t);
            }
        } else {
            for (T t : items) {
                this.template.save(t);
            }
        }
    }
}

