/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.transform;

import java.util.Locale;
import org.springframework.batch.item.file.transform.ExtractorLineAggregator;
import org.springframework.util.Assert;

public class FormatterLineAggregator<T>
extends ExtractorLineAggregator<T> {
    private String format;
    private Locale locale = Locale.getDefault();
    private int maximumLength = 0;
    private int minimumLength = 0;

    public void setMinimumLength(int minimumLength) {
        this.minimumLength = minimumLength;
    }

    public void setMaximumLength(int maximumLength) {
        this.maximumLength = maximumLength;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    protected String doAggregate(Object[] fields) {
        Assert.notNull(this.format);
        String value = String.format(this.locale, this.format, fields);
        if (this.maximumLength > 0) {
            Assert.state(value.length() <= this.maximumLength, String.format("String overflowed in formatter - longer than %d characters: [%s", this.maximumLength, value));
        }
        if (this.minimumLength > 0) {
            Assert.state(value.length() >= this.minimumLength, String.format("String underflowed in formatter - shorter than %d characters: [%s", this.minimumLength, value));
        }
        return value;
    }
}

