/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.support;

import java.util.List;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemStreamWriter;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class CompositeItemWriter<T>
implements ItemStreamWriter<T>,
InitializingBean {
    private List<ItemWriter<? super T>> delegates;
    private boolean ignoreItemStream = false;

    public void setIgnoreItemStream(boolean ignoreItemStream) {
        this.ignoreItemStream = ignoreItemStream;
    }

    @Override
    public void write(List<? extends T> item) throws Exception {
        for (ItemWriter<? extends T> itemWriter : this.delegates) {
            itemWriter.write(item);
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.delegates, "The 'delegates' may not be null");
        Assert.notEmpty(this.delegates, "The 'delegates' may not be empty");
    }

    public void setDelegates(List<ItemWriter<? super T>> delegates) {
        this.delegates = delegates;
    }

    @Override
    public void close() throws ItemStreamException {
        for (ItemWriter<? super T> itemWriter : this.delegates) {
            if (this.ignoreItemStream || !(itemWriter instanceof ItemStream)) continue;
            ((ItemStream)((Object)itemWriter)).close();
        }
    }

    @Override
    public void open(ExecutionContext executionContext) throws ItemStreamException {
        for (ItemWriter<? super T> itemWriter : this.delegates) {
            if (this.ignoreItemStream || !(itemWriter instanceof ItemStream)) continue;
            ((ItemStream)((Object)itemWriter)).open(executionContext);
        }
    }

    @Override
    public void update(ExecutionContext executionContext) throws ItemStreamException {
        for (ItemWriter<? super T> itemWriter : this.delegates) {
            if (this.ignoreItemStream || !(itemWriter instanceof ItemStream)) continue;
            ((ItemStream)((Object)itemWriter)).update(executionContext);
        }
    }
}

