/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.QueryHint;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.jpa.repository.query.Jpa21Utils;
import org.springframework.data.jpa.repository.query.JpaQueryExecution;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.util.Assert;

public abstract class AbstractJpaQuery
implements RepositoryQuery {
    private final JpaQueryMethod method;
    private final EntityManager em;

    public AbstractJpaQuery(JpaQueryMethod method, EntityManager em) {
        Assert.notNull(method);
        Assert.notNull(em);
        this.method = method;
        this.em = em;
    }

    @Override
    public JpaQueryMethod getQueryMethod() {
        return this.method;
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }

    @Override
    public Object execute(Object[] parameters) {
        return this.doExecute(this.getExecution(), parameters);
    }

    private Object doExecute(JpaQueryExecution execution, Object[] values2) {
        Object result = execution.execute(this, values2);
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.method.getParameters(), values2);
        ResultProcessor withDynamicProjection = this.method.getResultProcessor().withDynamicProjection(accessor);
        return withDynamicProjection.processResult(result, TupleConverter.INSTANCE);
    }

    protected JpaQueryExecution getExecution() {
        if (this.method.isStreamQuery()) {
            return new JpaQueryExecution.StreamExecution();
        }
        if (this.method.isProcedureQuery()) {
            return new JpaQueryExecution.ProcedureExecution();
        }
        if (this.method.isCollectionQuery()) {
            return new JpaQueryExecution.CollectionExecution();
        }
        if (this.method.isSliceQuery()) {
            return new JpaQueryExecution.SlicedExecution(this.method.getParameters());
        }
        if (this.method.isPageQuery()) {
            return new JpaQueryExecution.PagedExecution(this.method.getParameters());
        }
        if (this.method.isModifyingQuery()) {
            return this.method.getClearAutomatically() ? new JpaQueryExecution.ModifyingExecution(this.method, this.em) : new JpaQueryExecution.ModifyingExecution(this.method, null);
        }
        return new JpaQueryExecution.SingleEntityExecution();
    }

    protected <T extends Query> T applyHints(T query, JpaQueryMethod method) {
        for (QueryHint hint : method.getHints()) {
            this.applyQueryHint(query, hint);
        }
        return query;
    }

    protected <T extends Query> void applyQueryHint(T query, QueryHint hint) {
        Assert.notNull(query, "Query must not be null!");
        Assert.notNull(hint, "QueryHint must not be null!");
        query.setHint(hint.name(), hint.value());
    }

    private Query applyLockMode(Query query, JpaQueryMethod method) {
        LockModeType lockModeType = method.getLockModeType();
        return lockModeType == null ? query : query.setLockMode(lockModeType);
    }

    protected ParameterBinder createBinder(Object[] values2) {
        return new ParameterBinder(this.getQueryMethod().getParameters(), values2);
    }

    protected Query createQuery(Object[] values2) {
        return this.applyLockMode(this.applyEntityGraphConfiguration(this.applyHints(this.doCreateQuery(values2), this.method), this.method), this.method);
    }

    private Query applyEntityGraphConfiguration(Query query, JpaQueryMethod method) {
        Assert.notNull(query, "Query must not be null!");
        Assert.notNull(method, "JpaQueryMethod must not be null!");
        Map<String, Object> hints = Jpa21Utils.tryGetFetchGraphHints(this.em, method.getEntityGraph(), this.getQueryMethod().getEntityInformation().getJavaType());
        for (Map.Entry<String, Object> hint : hints.entrySet()) {
            query.setHint(hint.getKey(), hint.getValue());
        }
        return query;
    }

    protected Query createCountQuery(Object[] values2) {
        Query countQuery = this.doCreateCountQuery(values2);
        return this.method.applyHintsToCountQuery() ? this.applyHints(countQuery, this.method) : countQuery;
    }

    protected abstract Query doCreateQuery(Object[] var1);

    protected abstract Query doCreateCountQuery(Object[] var1);

    private static enum TupleConverter implements Converter<Object, Object>
    {
        INSTANCE;


        @Override
        public Object convert(Object source) {
            if (!(source instanceof Tuple)) {
                return source;
            }
            Tuple tuple = (Tuple)source;
            HashMap result = new HashMap();
            for (TupleElement<?> element : tuple.getElements()) {
                String alias = element.getAlias();
                if (alias == null || TupleConverter.isIndexAsString(alias)) {
                    throw new IllegalStateException("No aliases found in result tuple! Make sure your query defines aliases!");
                }
                result.put(element.getAlias(), tuple.get(element));
            }
            return result;
        }

        private static boolean isIndexAsString(String source) {
            try {
                Integer.parseInt(source);
                return true;
            }
            catch (NumberFormatException o_O) {
                return false;
            }
        }
    }
}

