/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.core.PriorityOrdered;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class FactoryBeanTypePredictingBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements BeanFactoryAware,
PriorityOrdered {
    private static final Logger LOGGER = LoggerFactory.getLogger(FactoryBeanTypePredictingBeanPostProcessor.class);
    private final Map<String, Class<?>> cache = new ConcurrentHashMap();
    private final Class<?> factoryBeanType;
    private final List<String> properties;
    private ConfigurableListableBeanFactory context;

    public FactoryBeanTypePredictingBeanPostProcessor(Class<?> factoryBeanType, String ... properties) {
        Assert.notNull(factoryBeanType, "FactoryBean type must not be null!");
        Assert.isTrue(FactoryBean.class.isAssignableFrom(factoryBeanType), "Given type is not a FactoryBean type!");
        Assert.notEmpty(properties, "Properties must not be empty!");
        for (String property : properties) {
            Assert.hasText(property, "Type property must not be null!");
        }
        this.factoryBeanType = factoryBeanType;
        this.properties = Arrays.asList(properties);
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.context = (ConfigurableListableBeanFactory)beanFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> predictBeanType(Class<?> beanClass, String beanName) {
        if (null == this.context || !this.factoryBeanType.isAssignableFrom(beanClass)) {
            return null;
        }
        Class<?> resolvedBeanClass = this.cache.get(beanName);
        if (resolvedBeanClass != null) {
            return resolvedBeanClass == Void.class ? null : resolvedBeanClass;
        }
        BeanDefinition definition = this.context.getBeanDefinition(beanName);
        try {
            for (String property : this.properties) {
                PropertyValue value = definition.getPropertyValues().getPropertyValue(property);
                resolvedBeanClass = this.getClassForPropertyValue(value, beanName);
                if (Void.class.equals(resolvedBeanClass)) continue;
                Class<?> clazz = resolvedBeanClass;
                return clazz;
            }
            Iterator<String> iterator2 = null;
            return iterator2;
        }
        finally {
            this.cache.put(beanName, resolvedBeanClass);
        }
    }

    private Class<?> getClassForPropertyValue(PropertyValue propertyValue, String beanName) {
        if (propertyValue == null) {
            return Void.class;
        }
        Object value = propertyValue.getValue();
        String className = null;
        if (value instanceof TypedStringValue) {
            className = ((TypedStringValue)value).getValue();
        } else if (value instanceof String) {
            className = (String)value;
        } else {
            if (value instanceof Class) {
                return (Class)value;
            }
            if (value instanceof String[]) {
                String[] values2 = (String[])value;
                if (values2.length == 0) {
                    return Void.class;
                }
                className = values2[0];
            } else {
                return Void.class;
            }
        }
        try {
            return ClassUtils.resolveClassName(className, this.context.getBeanClassLoader());
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warn(String.format("Couldn't load class %s referenced as repository interface in bean %s!", className, beanName));
            return Void.class;
        }
    }

    @Override
    public int getOrder() {
        return 0x7FFFFFFE;
    }
}

