/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpleemail.model.CloudWatchDestination;
import com.amazonaws.services.simpleemail.model.EventType;
import com.amazonaws.services.simpleemail.model.KinesisFirehoseDestination;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class EventDestination
implements Serializable,
Cloneable {
    private String name;
    private Boolean enabled;
    private SdkInternalList<String> matchingEventTypes;
    private KinesisFirehoseDestination kinesisFirehoseDestination;
    private CloudWatchDestination cloudWatchDestination;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public EventDestination withName(String name) {
        this.setName(name);
        return this;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public EventDestination withEnabled(Boolean enabled) {
        this.setEnabled(enabled);
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public List<String> getMatchingEventTypes() {
        if (this.matchingEventTypes == null) {
            this.matchingEventTypes = new SdkInternalList();
        }
        return this.matchingEventTypes;
    }

    public void setMatchingEventTypes(Collection<String> matchingEventTypes) {
        if (matchingEventTypes == null) {
            this.matchingEventTypes = null;
            return;
        }
        this.matchingEventTypes = new SdkInternalList<String>(matchingEventTypes);
    }

    public EventDestination withMatchingEventTypes(String ... matchingEventTypes) {
        if (this.matchingEventTypes == null) {
            this.setMatchingEventTypes(new SdkInternalList<String>(matchingEventTypes.length));
        }
        for (String ele : matchingEventTypes) {
            this.matchingEventTypes.add(ele);
        }
        return this;
    }

    public EventDestination withMatchingEventTypes(Collection<String> matchingEventTypes) {
        this.setMatchingEventTypes(matchingEventTypes);
        return this;
    }

    public EventDestination withMatchingEventTypes(EventType ... matchingEventTypes) {
        SdkInternalList<String> matchingEventTypesCopy = new SdkInternalList<String>(matchingEventTypes.length);
        for (EventType value : matchingEventTypes) {
            matchingEventTypesCopy.add(value.toString());
        }
        if (this.getMatchingEventTypes() == null) {
            this.setMatchingEventTypes(matchingEventTypesCopy);
        } else {
            this.getMatchingEventTypes().addAll(matchingEventTypesCopy);
        }
        return this;
    }

    public void setKinesisFirehoseDestination(KinesisFirehoseDestination kinesisFirehoseDestination) {
        this.kinesisFirehoseDestination = kinesisFirehoseDestination;
    }

    public KinesisFirehoseDestination getKinesisFirehoseDestination() {
        return this.kinesisFirehoseDestination;
    }

    public EventDestination withKinesisFirehoseDestination(KinesisFirehoseDestination kinesisFirehoseDestination) {
        this.setKinesisFirehoseDestination(kinesisFirehoseDestination);
        return this;
    }

    public void setCloudWatchDestination(CloudWatchDestination cloudWatchDestination) {
        this.cloudWatchDestination = cloudWatchDestination;
    }

    public CloudWatchDestination getCloudWatchDestination() {
        return this.cloudWatchDestination;
    }

    public EventDestination withCloudWatchDestination(CloudWatchDestination cloudWatchDestination) {
        this.setCloudWatchDestination(cloudWatchDestination);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getEnabled() != null) {
            sb.append("Enabled: ").append(this.getEnabled()).append(",");
        }
        if (this.getMatchingEventTypes() != null) {
            sb.append("MatchingEventTypes: ").append(this.getMatchingEventTypes()).append(",");
        }
        if (this.getKinesisFirehoseDestination() != null) {
            sb.append("KinesisFirehoseDestination: ").append(this.getKinesisFirehoseDestination()).append(",");
        }
        if (this.getCloudWatchDestination() != null) {
            sb.append("CloudWatchDestination: ").append(this.getCloudWatchDestination());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventDestination)) {
            return false;
        }
        EventDestination other = (EventDestination)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getEnabled() == null ^ this.getEnabled() == null) {
            return false;
        }
        if (other.getEnabled() != null && !other.getEnabled().equals(this.getEnabled())) {
            return false;
        }
        if (other.getMatchingEventTypes() == null ^ this.getMatchingEventTypes() == null) {
            return false;
        }
        if (other.getMatchingEventTypes() != null && !other.getMatchingEventTypes().equals(this.getMatchingEventTypes())) {
            return false;
        }
        if (other.getKinesisFirehoseDestination() == null ^ this.getKinesisFirehoseDestination() == null) {
            return false;
        }
        if (other.getKinesisFirehoseDestination() != null && !other.getKinesisFirehoseDestination().equals(this.getKinesisFirehoseDestination())) {
            return false;
        }
        if (other.getCloudWatchDestination() == null ^ this.getCloudWatchDestination() == null) {
            return false;
        }
        return other.getCloudWatchDestination() == null || other.getCloudWatchDestination().equals(this.getCloudWatchDestination());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode2 = 1;
        hashCode2 = 31 * hashCode2 + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getEnabled() == null ? 0 : this.getEnabled().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getMatchingEventTypes() == null ? 0 : this.getMatchingEventTypes().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getKinesisFirehoseDestination() == null ? 0 : this.getKinesisFirehoseDestination().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getCloudWatchDestination() == null ? 0 : this.getCloudWatchDestination().hashCode());
        return hashCode2;
    }

    public EventDestination clone() {
        try {
            return (EventDestination)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

