/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.text.Format;
import java.util.Locale;
import org.apache.commons.validator.routines.AbstractNumberValidator;

public class IntegerValidator
extends AbstractNumberValidator {
    private static final long serialVersionUID = 422081746310306596L;
    private static final IntegerValidator VALIDATOR = new IntegerValidator();

    public static IntegerValidator getInstance() {
        return VALIDATOR;
    }

    public IntegerValidator() {
        this(true, 0);
    }

    public IntegerValidator(boolean strict, int formatType) {
        super(strict, formatType, false);
    }

    public Integer validate(String value) {
        return (Integer)this.parse(value, null, null);
    }

    public Integer validate(String value, String pattern) {
        return (Integer)this.parse(value, pattern, null);
    }

    public Integer validate(String value, Locale locale) {
        return (Integer)this.parse(value, null, locale);
    }

    public Integer validate(String value, String pattern, Locale locale) {
        return (Integer)this.parse(value, pattern, locale);
    }

    public boolean isInRange(int value, int min2, int max2) {
        return value >= min2 && value <= max2;
    }

    public boolean isInRange(Integer value, int min2, int max2) {
        return this.isInRange((int)value, min2, max2);
    }

    public boolean minValue(int value, int min2) {
        return value >= min2;
    }

    public boolean minValue(Integer value, int min2) {
        return this.minValue((int)value, min2);
    }

    public boolean maxValue(int value, int max2) {
        return value <= max2;
    }

    public boolean maxValue(Integer value, int max2) {
        return this.maxValue((int)value, max2);
    }

    @Override
    protected Object processParsedValue(Object value, Format formatter) {
        long longValue = ((Number)value).longValue();
        if (longValue < Integer.MIN_VALUE || longValue > Integer.MAX_VALUE) {
            return null;
        }
        return new Integer((int)longValue);
    }
}

