/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.notification;

import java.util.Collection;
import org.duracloud.common.notification.NotificationConfig;
import org.duracloud.common.notification.NotificationType;
import org.duracloud.common.notification.Notifier;

public class NotificationManager {
    private Notifier[] notifiers;

    public NotificationManager(Notifier ... notifiers) {
        this.notifiers = notifiers;
    }

    public void initializeNotifiers(Collection<NotificationConfig> notificationConfigs) {
        for (NotificationConfig config : notificationConfigs) {
            for (Notifier notifier : this.notifiers) {
                if (!notifier.getNotificationType().name().equalsIgnoreCase(config.getType())) continue;
                notifier.initialize(config);
            }
        }
    }

    public void sendNotification(NotificationType type, String subject, String message, String ... destinations) {
        for (Notifier notifier : this.notifiers) {
            if (!notifier.getNotificationType().equals((Object)type)) continue;
            notifier.notify(subject, message, destinations);
        }
    }

    public void sendAdminNotification(NotificationType type, String subject, String message) {
        for (Notifier notifier : this.notifiers) {
            if (!notifier.getNotificationType().equals((Object)type)) continue;
            notifier.notifyAdmins(subject, message);
        }
    }
}

