/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.service.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.duracloud.chunk.util.ChunkUtil;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.common.model.ContentItem;
import org.duracloud.common.retry.Retriable;
import org.duracloud.common.retry.Retrier;
import org.duracloud.common.util.ChecksumUtil;
import org.duracloud.retrieval.mgmt.OutputWriter;
import org.duracloud.retrieval.mgmt.RetrievalListener;
import org.duracloud.retrieval.mgmt.RetrievalWorker;
import org.duracloud.retrieval.source.RetrievalSource;
import org.duracloud.snapshot.db.model.Snapshot;
import org.duracloud.snapshot.service.SnapshotManager;
import org.duracloud.snapshot.service.impl.ManifestEntry;
import org.duracloud.snapshot.service.impl.ManifestFileHelper;
import org.duracloud.snapshot.service.impl.PropertiesSerializer;
import org.duracloud.snapshot.service.impl.SpaceManifestSnapshotManifestVerifier;
import org.duracloud.snapshot.service.impl.StepExecutionSupport;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.item.ItemWriter;

public class SpaceItemWriter
extends StepExecutionSupport
implements ItemWriter<ContentItem>,
ItemWriteListener<ContentItem> {
    private static final Logger log = LoggerFactory.getLogger(SpaceItemWriter.class);
    private RetrievalSource retrievalSource;
    private File contentDir;
    private OutputWriter outputWriter;
    private BufferedWriter propsWriter;
    private BufferedWriter md5Writer;
    private BufferedWriter sha256Writer;
    private ContentItem snapshotPropsContentItem;
    private SnapshotManager snapshotManager;
    private Snapshot snapshot;
    private List<String> errors = new LinkedList<String>();
    private SpaceManifestSnapshotManifestVerifier spaceManifestSnapshotManifestVerifier;
    private ChunkUtil chunkUtil = new ChunkUtil();
    private Map<String, String> md5Cache = new HashMap<String, String>();
    private Map<String, String> sha256Cache = new HashMap<String, String>();
    private Map<String, String> propsCache = new HashMap<String, String>();
    private File md5ManifestFile;
    private File sha256ManifestFile;
    private File propsFile;
    private DB db;
    private File dbFile;
    private int totalChecksumsPerformed = 0;

    public SpaceItemWriter(Snapshot snapshot, RetrievalSource retrievalSource, File contentDir, OutputWriter outputWriter, File propsFile, File md5ManifestFile, File sha256ManifestFile, SnapshotManager snapshotManager, SpaceManifestSnapshotManifestVerifier spaceManifestSnapshotManifestVerifier) {
        this.snapshot = snapshot;
        this.retrievalSource = retrievalSource;
        this.contentDir = contentDir;
        this.outputWriter = outputWriter;
        this.md5ManifestFile = md5ManifestFile;
        this.sha256ManifestFile = sha256ManifestFile;
        this.snapshotManager = snapshotManager;
        this.spaceManifestSnapshotManifestVerifier = spaceManifestSnapshotManifestVerifier;
        this.dbFile = new File(contentDir, snapshot.getName() + ".db");
        this.propsFile = propsFile;
    }

    private DB makeDatabase() {
        return DBMaker.fileDB(this.dbFile).transactionEnable().closeOnJvmShutdown().make();
    }

    protected void closeDatabase() {
        if (this.db != null) {
            this.db.close();
        }
    }

    protected void deleteDatabase() {
        this.closeDatabase();
        this.dbFile.delete();
    }

    private BufferedWriter createWriter(File file) throws IOException {
        BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
        return writer;
    }

    @Override
    public void write(List<? extends ContentItem> items) throws IOException {
        for (ContentItem contentItem : items) {
            String contentId = contentItem.getContentId();
            log.debug("writing: {}", (Object)contentId);
            if (!contentId.equals(".collection-snapshot.properties")) {
                File dataDir = this.getDataDir();
                this.retrieveFile(contentItem, dataDir);
                continue;
            }
            this.snapshotPropsContentItem = contentItem;
        }
    }

    private File getDataDir() {
        return new File(this.contentDir, "data");
    }

    protected void retrieveFile(ContentItem contentItem, File directory) throws IOException {
        this.retrieveFile(contentItem, directory, true, false);
    }

    private void cacheValue(Map<String, String> cache, String key, String value) {
        cache.put(key, value);
        this.db.commit();
    }

    protected void retrieveFile(ContentItem contentItem, File directory, boolean writeChecksums, boolean lastItem) throws IOException {
        String contentId = this.chunkUtil.preChunkedContentId(contentItem.getContentId());
        String md5Checksum = this.md5Cache.get(contentId);
        String sha256 = this.sha256Cache.get(contentId);
        Map<String, String> props = null;
        RetrievalWorker retrievalWorker = new RetrievalWorker(contentItem, this.retrievalSource, directory, true, this.outputWriter, false, true);
        File localFile = retrievalWorker.getLocalFile();
        if (md5Checksum == null) {
            StopWatch sw = new StopWatch();
            sw.start();
            props = retrievalWorker.retrieveFile(new RetrievalListener(){

                @Override
                public void chunkRetrieved(String chunk) {
                    SpaceItemWriter.this.getStepExecution().getExecutionContext().put("last-chunk-retrieved-" + Thread.currentThread().getName(), chunk);
                }
            });
            sw.stop();
            if (null == props) {
                throw new IOException("Failed to retrieve " + contentId + " after " + sw.getTime() / 1000L + " seconds");
            }
            log.info("Finished retrieving content: contentId={},  fileSize={}, file path={}, elapsedTimeMs={}, transferRateMbps={}", contentId, localFile.length(), localFile.getAbsolutePath(), sw.getTime(), (double)localFile.length() * 0.008 / (double)sw.getTime());
            this.cacheValue(this.propsCache, contentId, PropertiesSerializer.serialize(props));
            md5Checksum = props.get("content-checksum");
            this.cacheValue(this.md5Cache, contentId, md5Checksum);
            log.info("Retrieved item {} from space {} with MD5 checksum {}", contentItem.getContentId(), contentItem.getSpaceId(), md5Checksum);
        } else {
            log.info("MD5 for contentId {} is already cached. No need to download and reverify.", (Object)contentId);
            String propsStr = this.propsCache.get(contentId);
            if (propsStr != null) {
                props = PropertiesSerializer.deserialize(propsStr);
                log.info("Props found in cache for {}.", (Object)contentId);
            } else {
                log.info("Props not found in cache for {}.", (Object)contentId);
                props = this.retrievalSource.getSourceProperties(contentItem);
                this.cacheValue(this.propsCache, contentId, PropertiesSerializer.serialize(props));
                log.info("Retrieved and cached props for {}.", (Object)contentId);
            }
        }
        if (localFile.exists() && md5Checksum != null) {
            try {
                if (writeChecksums) {
                    this.writeMD5Checksum(contentId, md5Checksum);
                    if (sha256 == null) {
                        ChecksumUtil sha256ChecksumUtil = new ChecksumUtil(ChecksumUtil.Algorithm.SHA_256);
                        StopWatch sw = new StopWatch();
                        log.info("Starting sha256 checksum generation for contentId={}; file path={}", (Object)contentId, (Object)localFile.getAbsolutePath());
                        sw.start();
                        sha256 = sha256ChecksumUtil.generateChecksum(localFile);
                        ++this.totalChecksumsPerformed;
                        sw.stop();
                        log.info("Finished sha256 checksum generation for contentId={}; fileSize={}, file path={}; elapsedTimeMs={}", contentId, localFile.length(), localFile.getAbsolutePath(), sw.getTime());
                        this.cacheValue(this.sha256Cache, contentId, sha256);
                    } else {
                        log.info("SHA-256 checksum for contentId {} is already cached, no need to recompute", (Object)contentId);
                    }
                    this.writeSHA256Checksum(contentId, sha256);
                }
                this.writeToSnapshotManager(contentId, props);
                this.writeContentProperties(contentId, props, lastItem);
            }
            catch (IOException ioe) {
                log.error("Error writing snapshot details: " + ioe.getMessage());
                throw ioe;
            }
        } else {
            String baseError = "Retrieved item " + contentItem.getContentId() + " from space " + contentItem.getSpaceId() + " could not be processed due to: ";
            if (!localFile.exists()) {
                String error = baseError + "The local file at path " + localFile.getAbsolutePath() + " could not be found.";
                log.error(error);
                throw new IOException(error);
            }
            String error = baseError + "MD5 checksum for retrieved file was null";
            log.error(error);
            throw new IOException(error);
        }
    }

    protected int getTotalChecksumsPerformed() {
        return this.totalChecksumsPerformed;
    }

    private void writeToSnapshotManager(final String contentId, final Map<String, String> props) throws IOException {
        try {
            new Retrier().execute(new Retriable(){

                @Override
                public Object retry() throws Exception {
                    SpaceItemWriter.this.snapshotManager.addContentItem(SpaceItemWriter.this.snapshot, contentId, props);
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to add snapshot content item: " + contentId + " to snapshot " + this.snapshot + ": " + e.getMessage(), e);
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeMD5Checksum(String contentId, String md5Checksum) throws IOException {
        BufferedWriter bufferedWriter = this.md5Writer;
        synchronized (bufferedWriter) {
            ManifestFileHelper.writeManifestEntry(this.md5Writer, contentId, md5Checksum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeSHA256Checksum(String contentId, String sha256Checksum) throws IOException {
        BufferedWriter bufferedWriter = this.sha256Writer;
        synchronized (bufferedWriter) {
            ManifestFileHelper.writeManifestEntry(this.sha256Writer, contentId, sha256Checksum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeContentProperties(String contentId, Map<String, String> props, boolean lastItem) throws IOException {
        Set<String> propKeys = props.keySet();
        StringBuffer sb = new StringBuffer(100);
        sb.append("{\n  \"" + contentId + "\": {\n");
        for (String propKey : propKeys) {
            String propValue = props.get(propKey);
            propValue = propValue.replace("\\", "\\\\");
            propValue = propValue.replace("\"", "\\\"");
            sb.append("    \"" + propKey + "\": \"" + propValue + "\",\n");
        }
        sb.deleteCharAt(sb.length() - 2);
        sb.append("  }\n}");
        if (!lastItem) {
            sb.append(",");
        }
        sb.append("\n");
        BufferedWriter bufferedWriter = this.propsWriter;
        synchronized (bufferedWriter) {
            this.propsWriter.write(sb.toString());
            this.propsWriter.flush();
        }
    }

    protected void retrieveSnapshotProperties() {
        if (this.snapshotPropsContentItem != null) {
            try {
                this.retrieveFile(this.snapshotPropsContentItem, this.contentDir, false, true);
                log.info("Snapshot properties retrieved");
            }
            catch (IOException ioe) {
                log.error("Error retrieving the snapshot properties file: " + ioe.getMessage(), ioe);
            }
        } else {
            String message = "No snapshot properties file found. (.collection-snapshot.properties)";
            log.error(message);
            this.errors.add(message);
        }
    }

    @Override
    public ExitStatus afterStep(StepExecution stepExecution) {
        ExitStatus status = super.afterStep(stepExecution);
        log.info("Step complete with status: {}", (Object)stepExecution.getExitStatus());
        this.close("md5 writer", this.md5Writer);
        this.close("sh256 writer", this.sha256Writer);
        this.close("output writer", this.outputWriter);
        this.retrieveSnapshotProperties();
        this.closePropsWriter();
        if (this.errors.size() == 0) {
            log.info("No errors in retrieval of snapshot {}; Proceeding with space manifest - snapshot manifest verification...", (Object)this.snapshot.getName());
            this.errors.addAll(this.verifySpace(this.spaceManifestSnapshotManifestVerifier));
        }
        if (this.errors.size() > 0) {
            stepExecution.upgradeStatus(BatchStatus.FAILED);
            status = status.and(ExitStatus.FAILED);
            for (String error : this.errors) {
                status = status.addExitDescription(error);
            }
            log.error("Space item writer failed due to the following error(s): " + status.getExitDescription());
        }
        this.deleteDatabase();
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closePropsWriter() {
        try {
            BufferedWriter bufferedWriter = this.propsWriter;
            synchronized (bufferedWriter) {
                this.propsWriter.write("]\n");
                this.propsWriter.flush();
            }
            log.debug("Closed props writer");
        }
        catch (IOException ioe) {
            String message = "Error writing end of content property manifest: " + ioe.getMessage();
            this.errors.add(message);
            log.error(message, ioe);
        }
        finally {
            IOUtils.closeQuietly(this.propsWriter);
        }
    }

    private void close(String writerName, Object writer) {
        try {
            if (writer instanceof Closeable) {
                ((Closeable)writer).close();
            } else if (writer instanceof OutputWriter) {
                ((OutputWriter)writer).close();
            } else {
                throw new DuraCloudRuntimeException(writerName + " is not a supported parameter type for this method.");
            }
            log.info("closed {}", (Object)writerName);
        }
        catch (IOException ioe) {
            String message = "Error closing " + writerName + " BufferedWriter: " + ioe.getMessage();
            this.errors.add(message);
            log.error(message, ioe);
        }
    }

    private void loadCacheFromFile(Map<String, String> cache, File file, Function<String, Boolean> isValidChecksum) throws IOException {
        if (cache.isEmpty() && file.exists()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    try {
                        ManifestEntry entry = ManifestFileHelper.parseManifestEntry(line);
                        String contentId = entry.getContentId();
                        String checksum = entry.getChecksum();
                        if (isValidChecksum.apply(checksum).booleanValue()) {
                            this.cacheValue(cache, contentId, checksum);
                            continue;
                        }
                        log.info("Checksum {} in manifest file {} was not a valid checksum: skipping.", (Object)checksum, (Object)file.getAbsolutePath());
                    }
                    catch (ParseException ex) {
                        log.info("Unable to parse line in manifest file {}. message={}. skipping: line={}", file.getAbsolutePath(), ex.getMessage(), line);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeStep(StepExecution stepExecution) {
        super.beforeStep(stepExecution);
        log.info("Starting step {}", (Object)stepExecution);
        try {
            this.db = this.makeDatabase();
            this.md5Cache = this.db.treeMap("md5Cache", Serializer.STRING, Serializer.STRING).createOrOpen();
            this.sha256Cache = this.db.treeMap("sha256Cache", Serializer.STRING, Serializer.STRING).createOrOpen();
            this.propsCache = this.db.treeMap("propsCache", Serializer.STRING, Serializer.STRING).createOrOpen();
            this.loadCacheFromFile(this.md5Cache, this.md5ManifestFile, x -> x != null && x.matches("[a-fA-F0-9]{32}"));
            this.loadCacheFromFile(this.sha256Cache, this.sha256ManifestFile, x -> x != null && x.matches("[a-fA-F0-9]{64}"));
            try {
                this.propsWriter = this.createWriter(this.propsFile);
                this.md5Writer = this.createWriter(this.md5ManifestFile);
                this.sha256Writer = this.createWriter(this.sha256ManifestFile);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            this.errors.clear();
            BufferedWriter ex = this.propsWriter;
            synchronized (ex) {
                this.propsWriter.write("[\n");
                this.propsWriter.flush();
            }
        }
        catch (IOException ioe) {
            log.error("Error writing start of content property manifest: ", ioe);
        }
    }

    @Override
    public void onWriteError(Exception e, List<? extends ContentItem> items) {
        StringBuilder sb = new StringBuilder();
        for (ContentItem contentItem : items) {
            sb.append(contentItem.getContentId() + ", ");
        }
        String message = "Error writing item(s): " + e.getMessage() + ": items=" + sb.toString();
        this.errors.add(message);
        log.error(message, e);
    }

    @Override
    public void beforeWrite(List<? extends ContentItem> items) {
    }

    @Override
    public void afterWrite(List<? extends ContentItem> items) {
    }
}

