/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.sync.mgmt;

import java.io.File;
import java.util.Date;
import org.duracloud.sync.endpoint.MonitoredFile;
import org.duracloud.sync.endpoint.SyncEndpoint;
import org.duracloud.sync.endpoint.SyncResultType;
import org.duracloud.sync.mgmt.ChangedFile;
import org.duracloud.sync.mgmt.ChangedList;
import org.duracloud.sync.mgmt.StatusManager;
import org.duracloud.sync.mgmt.SyncSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncWorker
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(SyncWorker.class);
    private static final int MAX_RETRIES = 5;
    private ChangedFile syncFile;
    private File watchDir;
    private SyncEndpoint syncEndpoint;
    private StatusManager statusManager;
    private boolean complete;
    private MonitoredFile monitoredFile;
    private Date start;
    private Date stop;

    public SyncWorker(ChangedFile file, File watchDir, SyncEndpoint endpoint) {
        this.syncFile = file;
        this.watchDir = watchDir;
        this.syncEndpoint = endpoint;
        this.statusManager = StatusManager.getInstance();
        this.complete = false;
        this.monitoredFile = new MonitoredFile(this.syncFile.getFile());
    }

    @Override
    public void run() {
        SyncResultType result;
        this.start = new Date();
        File file = this.syncFile.getFile();
        String filePath = null != file ? file.getAbsolutePath() : "null";
        try {
            result = this.syncEndpoint.syncFileAndReturnDetailedResult(this.monitoredFile, this.watchDir);
            this.stop = new Date();
        }
        catch (Exception e) {
            this.logger.error("Exception syncing file " + filePath + " was " + e.getMessage(), e);
            result = SyncResultType.FAILED;
        }
        try {
            if (result != SyncResultType.FAILED) {
                SyncSummary summary = new SyncSummary(file, this.start, this.stop, result, "");
                this.statusManager.successfulCompletion(summary);
            } else {
                this.retryOnFailure();
            }
        }
        catch (Throwable e) {
            this.logger.error("Unexpected error: " + e.getMessage() + " - sync result = " + result + "; file=" + filePath, e);
        }
        this.syncFile.remove();
        this.complete = true;
    }

    public boolean isComplete() {
        return this.complete;
    }

    private void retryOnFailure() {
        int syncAttempts = this.syncFile.getSyncAttempts();
        String syncFilePath = this.syncFile.getFile().getAbsolutePath();
        if (syncAttempts < 5) {
            this.logger.info("Adding " + syncFilePath + " back to the changed list, another attempt will be made to sync file.");
            this.syncFile.incrementSyncAttempts();
            ChangedList.getInstance().addChangedFile(this.syncFile);
            this.statusManager.stoppingWork();
        } else {
            SyncSummary summary = new SyncSummary(this.syncFile.getFile(), this.start, this.stop, SyncResultType.FAILED, "Failed after " + syncAttempts + " attempts.");
            this.statusManager.failedCompletion(summary);
            this.logger.error("Failed to sync file " + syncFilePath + " after " + syncAttempts + " attempts. No further attempts will be made.");
        }
    }

    public MonitoredFile getMonitoredFile() {
        return this.monitoredFile;
    }
}

