/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ByteShortPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteShortProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableShortCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.map.primitive.ByteShortMap;
import org.eclipse.collections.api.map.primitive.ImmutableByteShortMap;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.tuple.primitive.ByteShortPair;
import org.eclipse.collections.impl.bag.mutable.primitive.ShortHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableShortCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.ByteLists;
import org.eclipse.collections.impl.factory.primitive.ByteShortMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableShortIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.ShortArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.ByteShortHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableByteSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableByteShortSingletonMap
implements ImmutableByteShortMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final short EMPTY_VALUE = 0;
    private final byte key1;
    private final short value1;

    ImmutableByteShortSingletonMap(byte key1, short value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    @Override
    public short get(byte key) {
        return this.getIfAbsent(key, (short)0);
    }

    @Override
    public short getIfAbsent(byte key, short ifAbsent) {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    @Override
    public short getOrThrow(byte key) {
        if (this.key1 == key) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(byte key) {
        return this.key1 == key;
    }

    @Override
    public boolean containsValue(short value) {
        return this.value1 == value;
    }

    @Override
    public void forEachValue(ShortProcedure procedure) {
        procedure.value(this.value1);
    }

    @Override
    public void forEachKey(ByteProcedure procedure) {
        procedure.value(this.key1);
    }

    @Override
    public void forEachKeyValue(ByteShortProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    @Override
    public LazyByteIterable keysView() {
        return ByteLists.immutable.of(this.key1).asLazy();
    }

    @Override
    public RichIterable<ByteShortPair> keyValuesView() {
        return Lists.immutable.of(PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    @Override
    public ImmutableByteShortMap select(ByteShortPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? ByteShortHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new ByteShortHashMap().toImmutable();
    }

    @Override
    public ImmutableByteShortMap reject(ByteShortPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new ByteShortHashMap().toImmutable() : ByteShortHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, this.value1);
    }

    @Override
    public ImmutableByteShortMap toImmutable() {
        return this;
    }

    @Override
    public ShortIterator shortIterator() {
        return new UnmodifiableShortIterator(ByteShortHashMap.newWithKeysValues(this.key1, this.value1).shortIterator());
    }

    @Override
    public void forEach(ShortProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(ShortProcedure procedure) {
        procedure.value(this.value1);
    }

    @Override
    public int count(ShortPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    @Override
    public long sum() {
        return this.value1;
    }

    @Override
    public short min() {
        return this.value1;
    }

    @Override
    public short max() {
        return this.value1;
    }

    @Override
    public short maxIfEmpty(short defaultValue) {
        return this.value1;
    }

    @Override
    public short minIfEmpty(short defaultValue) {
        return this.value1;
    }

    @Override
    public double average() {
        return this.value1;
    }

    @Override
    public double median() {
        return this.value1;
    }

    @Override
    public short[] toSortedArray() {
        return new short[]{this.value1};
    }

    @Override
    public MutableShortList toSortedList() {
        return ShortArrayList.newListWith(this.value1);
    }

    @Override
    public boolean anySatisfy(ShortPredicate predicate) {
        return predicate.accept(this.value1);
    }

    @Override
    public boolean allSatisfy(ShortPredicate predicate) {
        return predicate.accept(this.value1);
    }

    @Override
    public boolean noneSatisfy(ShortPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    @Override
    public ImmutableShortCollection select(ShortPredicate predicate) {
        return predicate.accept(this.value1) ? ShortArrayList.newListWith(this.value1).toImmutable() : new ShortArrayList().toImmutable();
    }

    @Override
    public ImmutableShortCollection reject(ShortPredicate predicate) {
        return predicate.accept(this.value1) ? new ShortArrayList().toImmutable() : ShortArrayList.newListWith(this.value1).toImmutable();
    }

    @Override
    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    @Override
    public <V> ImmutableCollection<V> collect(ShortToObjectFunction<? extends V> function) {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    @Override
    public short[] toArray() {
        return new short[]{this.value1};
    }

    @Override
    public boolean contains(short value) {
        return this.value1 == value;
    }

    @Override
    public boolean containsAll(short ... source) {
        for (short value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(ShortIterable source) {
        ShortIterator iterator2 = source.shortIterator();
        while (iterator2.hasNext()) {
            if (this.value1 == iterator2.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public MutableShortList toList() {
        return ShortArrayList.newListWith(this.value1);
    }

    @Override
    public MutableShortSet toSet() {
        return ShortHashSet.newSetWith(this.value1);
    }

    @Override
    public MutableShortBag toBag() {
        return ShortHashBag.newBagWith(this.value1);
    }

    @Override
    public LazyShortIterable asLazy() {
        return new LazyShortIterableAdapter(this);
    }

    @Override
    public ImmutableByteShortMap newWithKeyValue(byte key, short value) {
        return ByteShortMaps.immutable.withAll(ByteShortHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    @Override
    public ImmutableByteShortMap newWithoutKey(byte key) {
        return this.key1 == key ? ByteShortMaps.immutable.with() : this;
    }

    @Override
    public ImmutableByteShortMap newWithoutAllKeys(ByteIterable keys) {
        return keys.contains(this.key1) ? ByteShortMaps.immutable.with() : this;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public MutableByteSet keySet() {
        return UnmodifiableByteSet.of(ByteHashSet.newSetWith(this.key1));
    }

    @Override
    public MutableShortCollection values() {
        return UnmodifiableShortCollection.of(ShortArrayList.newListWith(this.value1));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ByteShortMap)) {
            return false;
        }
        ByteShortMap map2 = (ByteShortMap)obj;
        if (map2.size() != 1) {
            return false;
        }
        return map2.containsKey(this.key1) && this.value1 == map2.getOrThrow(this.key1);
    }

    @Override
    public int hashCode() {
        return this.key1 ^ this.value1;
    }

    @Override
    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

