/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import java.util.Iterator;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.HibernateIterator;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

public final class Hibernate {
    private Hibernate() {
        throw new UnsupportedOperationException();
    }

    public static void initialize(Object proxy) throws HibernateException {
        if (proxy == null) {
            return;
        }
        if (proxy instanceof HibernateProxy) {
            ((HibernateProxy)proxy).getHibernateLazyInitializer().initialize();
        } else if (proxy instanceof PersistentCollection) {
            ((PersistentCollection)proxy).forceInitialization();
        }
    }

    public static boolean isInitialized(Object proxy) {
        if (proxy instanceof HibernateProxy) {
            return !((HibernateProxy)proxy).getHibernateLazyInitializer().isUninitialized();
        }
        if (proxy instanceof PersistentCollection) {
            return ((PersistentCollection)proxy).wasInitialized();
        }
        return true;
    }

    public static Class getClass(Object proxy) {
        if (proxy instanceof HibernateProxy) {
            return ((HibernateProxy)proxy).getHibernateLazyInitializer().getImplementation().getClass();
        }
        return proxy.getClass();
    }

    public static LobCreator getLobCreator(Session session) {
        return Hibernate.getLobCreator((SessionImplementor)((Object)session));
    }

    public static LobCreator getLobCreator(SessionImplementor session) {
        return session.getFactory().getServiceRegistry().getService(JdbcServices.class).getLobCreator(session);
    }

    public static void close(Iterator iterator2) throws HibernateException {
        if (!(iterator2 instanceof HibernateIterator)) {
            throw new IllegalArgumentException("not a Hibernate iterator");
        }
        ((HibernateIterator)iterator2).close();
    }

    public static boolean isPropertyInitialized(Object proxy, String propertyName) {
        PersistentAttributeInterceptor interceptor;
        Object entity;
        if (proxy instanceof HibernateProxy) {
            LazyInitializer li = ((HibernateProxy)proxy).getHibernateLazyInitializer();
            if (li.isUninitialized()) {
                return false;
            }
            entity = li.getImplementation();
        } else {
            entity = proxy;
        }
        if (entity instanceof PersistentAttributeInterceptable && (interceptor = ((PersistentAttributeInterceptable)entity).$$_hibernate_getInterceptor()) != null && interceptor instanceof LazyAttributeLoadingInterceptor) {
            return ((LazyAttributeLoadingInterceptor)interceptor).isAttributeLoaded(propertyName);
        }
        return true;
    }
}

