/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.io.Serializable;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.action.internal.AbstractEntityInsertAction;
import org.hibernate.action.internal.EntityIdentityInsertAction;
import org.hibernate.action.internal.EntityInsertAction;
import org.hibernate.classic.Lifecycle;
import org.hibernate.engine.internal.Cascade;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityEntryExtraState;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.AbstractReassociateEventListener;
import org.hibernate.event.internal.WrapVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;

public abstract class AbstractSaveEventListener
extends AbstractReassociateEventListener {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(AbstractSaveEventListener.class);

    protected Serializable saveWithRequestedId(Object entity, Serializable requestedId, String entityName, Object anything, EventSource source) {
        return this.performSave(entity, requestedId, source.getEntityPersister(entityName, entity), false, anything, source, true);
    }

    protected Serializable saveWithGeneratedId(Object entity, String entityName, Object anything, EventSource source, boolean requiresImmediateIdAccess) {
        EntityPersister persister;
        Serializable generatedId;
        if (entity instanceof SelfDirtinessTracker) {
            ((SelfDirtinessTracker)entity).$$_hibernate_clearDirtyAttributes();
        }
        if ((generatedId = (persister = source.getEntityPersister(entityName, entity)).getIdentifierGenerator().generate(source, entity)) == null) {
            throw new IdentifierGenerationException("null id generated for:" + entity.getClass());
        }
        if (generatedId == IdentifierGeneratorHelper.SHORT_CIRCUIT_INDICATOR) {
            return source.getIdentifier(entity);
        }
        if (generatedId == IdentifierGeneratorHelper.POST_INSERT_INDICATOR) {
            return this.performSave(entity, null, persister, true, anything, source, requiresImmediateIdAccess);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Generated identifier: %s, using strategy: %s", (Object)persister.getIdentifierType().toLoggableString(generatedId, source.getFactory()), (Object)persister.getIdentifierGenerator().getClass().getName());
        }
        return this.performSave(entity, generatedId, persister, false, anything, source, true);
    }

    protected Serializable performSave(Object entity, Serializable id, EntityPersister persister, boolean useIdentityColumn, Object anything, EventSource source, boolean requiresImmediateIdAccess) {
        EntityKey key;
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Saving {0}", (Object)MessageHelper.infoString(persister, id, source.getFactory()));
        }
        if (!useIdentityColumn) {
            key = source.generateEntityKey(id, persister);
            Object old = source.getPersistenceContext().getEntity(key);
            if (old != null) {
                if (source.getPersistenceContext().getEntry(old).getStatus() == Status.DELETED) {
                    source.forceFlush(source.getPersistenceContext().getEntry(old));
                } else {
                    throw new NonUniqueObjectException(id, persister.getEntityName());
                }
            }
            persister.setIdentifier(entity, id, source);
        } else {
            key = null;
        }
        if (this.invokeSaveLifecycle(entity, persister, source)) {
            return id;
        }
        return this.performSaveOrReplicate(entity, key, persister, useIdentityColumn, anything, source, requiresImmediateIdAccess);
    }

    protected boolean invokeSaveLifecycle(Object entity, EntityPersister persister, EventSource source) {
        if (persister.implementsLifecycle()) {
            LOG.debug("Calling onSave()");
            if (((Lifecycle)entity).onSave(source)) {
                LOG.debug("Insertion vetoed by onSave()");
                return true;
            }
        }
        return false;
    }

    protected Serializable performSaveOrReplicate(Object entity, EntityKey key, EntityPersister persister, boolean useIdentityColumn, Object anything, EventSource source, boolean requiresImmediateIdAccess) {
        EntityEntryExtraState extraState;
        EntityEntry newEntry;
        Serializable id = key == null ? null : key.getIdentifier();
        boolean inTxn = source.isTransactionInProgress();
        boolean shouldDelayIdentityInserts = !inTxn && !requiresImmediateIdAccess;
        EntityEntry original = source.getPersistenceContext().addEntry(entity, Status.SAVING, null, null, id, null, LockMode.WRITE, useIdentityColumn, persister, false);
        this.cascadeBeforeSave(source, persister, entity, anything);
        Object[] values2 = persister.getPropertyValuesToInsert(entity, this.getMergeMap(anything), source);
        Type[] types = persister.getPropertyTypes();
        boolean substitute = this.substituteValuesIfNecessary(entity, id, values2, persister, source);
        if (persister.hasCollections()) {
            boolean bl = substitute = substitute || this.visitCollectionsBeforeSave(entity, id, values2, types, source);
        }
        if (substitute) {
            persister.setPropertyValues(entity, values2);
        }
        TypeHelper.deepCopy(values2, types, persister.getPropertyUpdateability(), values2, source);
        AbstractEntityInsertAction insert = this.addInsertAction(values2, id, entity, persister, useIdentityColumn, source, shouldDelayIdentityInserts);
        this.cascadeAfterSave(source, persister, entity, anything);
        if (useIdentityColumn && insert.isEarlyInsert()) {
            if (!EntityIdentityInsertAction.class.isInstance(insert)) {
                throw new IllegalStateException("Insert should be using an identity column, but action is of unexpected type: " + insert.getClass().getName());
            }
            id = ((EntityIdentityInsertAction)insert).getGeneratedId();
            insert.handleNaturalIdPostSaveNotifications(id);
        }
        if ((newEntry = source.getPersistenceContext().getEntry(entity)) != original && (extraState = newEntry.getExtraState(EntityEntryExtraState.class)) == null) {
            newEntry.addExtraState(original.getExtraState(EntityEntryExtraState.class));
        }
        return id;
    }

    private AbstractEntityInsertAction addInsertAction(Object[] values2, Serializable id, Object entity, EntityPersister persister, boolean useIdentityColumn, EventSource source, boolean shouldDelayIdentityInserts) {
        if (useIdentityColumn) {
            EntityIdentityInsertAction insert = new EntityIdentityInsertAction(values2, entity, persister, this.isVersionIncrementDisabled(), source, shouldDelayIdentityInserts);
            source.getActionQueue().addAction(insert);
            return insert;
        }
        Object version = Versioning.getVersion(values2, persister);
        EntityInsertAction insert = new EntityInsertAction(id, values2, entity, version, persister, this.isVersionIncrementDisabled(), source);
        source.getActionQueue().addAction(insert);
        return insert;
    }

    protected Map getMergeMap(Object anything) {
        return null;
    }

    protected boolean isVersionIncrementDisabled() {
        return false;
    }

    protected boolean visitCollectionsBeforeSave(Object entity, Serializable id, Object[] values2, Type[] types, EventSource source) {
        WrapVisitor visitor = new WrapVisitor(source);
        visitor.processEntityPropertyValues(values2, types);
        return visitor.isSubstitutionRequired();
    }

    protected boolean substituteValuesIfNecessary(Object entity, Serializable id, Object[] values2, EntityPersister persister, SessionImplementor source) {
        boolean substitute = source.getInterceptor().onSave(entity, id, values2, persister.getPropertyNames(), persister.getPropertyTypes());
        if (persister.isVersioned()) {
            substitute = Versioning.seedVersion(values2, persister.getVersionProperty(), persister.getVersionType(), source) || substitute;
        }
        return substitute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeBeforeSave(EventSource source, EntityPersister persister, Object entity, Object anything) {
        source.getPersistenceContext().incrementCascadeLevel();
        try {
            Cascade.cascade(this.getCascadeAction(), CascadePoint.BEFORE_INSERT_AFTER_DELETE, source, persister, entity, anything);
        }
        finally {
            source.getPersistenceContext().decrementCascadeLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeAfterSave(EventSource source, EntityPersister persister, Object entity, Object anything) {
        source.getPersistenceContext().incrementCascadeLevel();
        try {
            Cascade.cascade(this.getCascadeAction(), CascadePoint.AFTER_INSERT_BEFORE_DELETE, source, persister, entity, anything);
        }
        finally {
            source.getPersistenceContext().decrementCascadeLevel();
        }
    }

    protected abstract CascadingAction getCascadeAction();

    protected EntityState getEntityState(Object entity, String entityName, EntityEntry entry, SessionImplementor source) {
        boolean traceEnabled = LOG.isTraceEnabled();
        if (entry != null) {
            if (entry.getStatus() != Status.DELETED) {
                if (traceEnabled) {
                    LOG.tracev("Persistent instance of: {0}", (Object)this.getLoggableName(entityName, entity));
                }
                return EntityState.PERSISTENT;
            }
            if (traceEnabled) {
                LOG.tracev("Deleted instance of: {0}", (Object)this.getLoggableName(entityName, entity));
            }
            return EntityState.DELETED;
        }
        if (ForeignKeys.isTransient(entityName, entity, this.getAssumedUnsaved(), source)) {
            if (traceEnabled) {
                LOG.tracev("Transient instance of: {0}", (Object)this.getLoggableName(entityName, entity));
            }
            return EntityState.TRANSIENT;
        }
        if (traceEnabled) {
            LOG.tracev("Detached instance of: {0}", (Object)this.getLoggableName(entityName, entity));
        }
        return EntityState.DETACHED;
    }

    protected String getLoggableName(String entityName, Object entity) {
        return entityName == null ? entity.getClass().getName() : entityName;
    }

    protected Boolean getAssumedUnsaved() {
        return null;
    }

    public static enum EntityState {
        PERSISTENT,
        TRANSIENT,
        DETACHED,
        DELETED;

    }
}

