/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.serializer;

import java.io.IOException;
import java.util.Comparator;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.serializer.SerializerLong;

public class SerializerLongPacked
extends SerializerLong {
    @Override
    public void serialize(DataOutput2 out, Long value) throws IOException {
        out.packLong(value);
    }

    @Override
    public Long deserialize(DataInput2 in, int available) throws IOException {
        return new Long(in.unpackLong());
    }

    @Override
    public void valueArraySerialize(DataOutput2 out, Object vals) throws IOException {
        for (long o : (long[])vals) {
            out.packLong(o);
        }
    }

    public long[] valueArrayDeserialize(DataInput2 in, int size2) throws IOException {
        long[] ret2 = new long[size2];
        in.unpackLongArray(ret2, 0, size2);
        return ret2;
    }

    @Override
    public int fixedSize() {
        return -1;
    }

    @Override
    public int valueArrayBinarySearch(Long key, DataInput2 input, int keysLen, Comparator comparator) throws IOException {
        if (comparator != this) {
            return super.valueArrayBinarySearch(key, input, keysLen, comparator);
        }
        long key2 = key;
        for (int pos = 0; pos < keysLen; ++pos) {
            long from = input.unpackLong();
            if (key2 > from) continue;
            input.unpackLongSkip(keysLen - pos - 1);
            return key2 == from ? pos : -(pos + 1);
        }
        return -(keysLen + 1);
    }

    @Override
    public Long valueArrayBinaryGet(DataInput2 input, int keysLen, int pos) throws IOException {
        input.unpackLongSkip(pos);
        return input.unpackLong();
    }
}

