/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.RepeatListener;
import org.springframework.batch.repeat.RepeatStatus;

public class CompositeRepeatListener
implements RepeatListener {
    private List<RepeatListener> listeners = new ArrayList<RepeatListener>();

    public void setListeners(RepeatListener[] listeners) {
        this.listeners = Arrays.asList(listeners);
    }

    public void register(RepeatListener listener2) {
        if (!this.listeners.contains(listener2)) {
            this.listeners.add(listener2);
        }
    }

    @Override
    public void after(RepeatContext context, RepeatStatus result) {
        for (RepeatListener listener2 : this.listeners) {
            listener2.after(context, result);
        }
    }

    @Override
    public void before(RepeatContext context) {
        for (RepeatListener listener2 : this.listeners) {
            listener2.before(context);
        }
    }

    @Override
    public void close(RepeatContext context) {
        for (RepeatListener listener2 : this.listeners) {
            listener2.close(context);
        }
    }

    @Override
    public void onError(RepeatContext context, Throwable e) {
        for (RepeatListener listener2 : this.listeners) {
            listener2.onError(context, e);
        }
    }

    @Override
    public void open(RepeatContext context) {
        for (RepeatListener listener2 : this.listeners) {
            listener2.open(context);
        }
    }
}

