/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.context;

import java.util.ArrayList;
import java.util.List;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DelegatingApplicationListener
implements ApplicationListener<ApplicationEvent> {
    private List<SmartApplicationListener> listeners = new ArrayList<SmartApplicationListener>();

    @Override
    public void onApplicationEvent(ApplicationEvent event) {
        if (event == null) {
            return;
        }
        for (SmartApplicationListener listener2 : this.listeners) {
            Object source = event.getSource();
            if (source == null || !listener2.supportsEventType(event.getClass()) || !listener2.supportsSourceType(source.getClass())) continue;
            listener2.onApplicationEvent(event);
        }
    }

    public void addListener(SmartApplicationListener smartApplicationListener) {
        Assert.notNull(smartApplicationListener, "smartApplicationListener cannot be null");
        this.listeners.add(smartApplicationListener);
    }
}

