/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpleemail.model.Body;
import com.amazonaws.services.simpleemail.model.Content;
import com.amazonaws.services.simpleemail.model.Destination;
import com.amazonaws.services.simpleemail.model.Message;
import com.amazonaws.services.simpleemail.model.MessageTag;
import com.amazonaws.services.simpleemail.model.SendEmailRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class SendEmailRequestMarshaller
implements Marshaller<Request<SendEmailRequest>, SendEmailRequest> {
    @Override
    public Request<SendEmailRequest> marshall(SendEmailRequest sendEmailRequest) {
        Message message;
        Destination destination;
        if (sendEmailRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SendEmailRequest> request = new DefaultRequest<SendEmailRequest>(sendEmailRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "SendEmail");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (sendEmailRequest.getSource() != null) {
            request.addParameter("Source", StringUtils.fromString(sendEmailRequest.getSource()));
        }
        if ((destination = sendEmailRequest.getDestination()) != null) {
            if (!destination.getToAddresses().isEmpty() || !((SdkInternalList)destination.getToAddresses()).isAutoConstruct()) {
                SdkInternalList toAddressesList = (SdkInternalList)destination.getToAddresses();
                int toAddressesListIndex = 1;
                for (String toAddressesListValue : toAddressesList) {
                    if (toAddressesListValue != null) {
                        request.addParameter("Destination.ToAddresses.member." + toAddressesListIndex, StringUtils.fromString(toAddressesListValue));
                    }
                    ++toAddressesListIndex;
                }
            }
            if (!destination.getCcAddresses().isEmpty() || !((SdkInternalList)destination.getCcAddresses()).isAutoConstruct()) {
                SdkInternalList ccAddressesList = (SdkInternalList)destination.getCcAddresses();
                int ccAddressesListIndex = 1;
                for (String ccAddressesListValue : ccAddressesList) {
                    if (ccAddressesListValue != null) {
                        request.addParameter("Destination.CcAddresses.member." + ccAddressesListIndex, StringUtils.fromString(ccAddressesListValue));
                    }
                    ++ccAddressesListIndex;
                }
            }
            if (!destination.getBccAddresses().isEmpty() || !((SdkInternalList)destination.getBccAddresses()).isAutoConstruct()) {
                SdkInternalList bccAddressesList = (SdkInternalList)destination.getBccAddresses();
                int bccAddressesListIndex = 1;
                for (String bccAddressesListValue : bccAddressesList) {
                    if (bccAddressesListValue != null) {
                        request.addParameter("Destination.BccAddresses.member." + bccAddressesListIndex, StringUtils.fromString(bccAddressesListValue));
                    }
                    ++bccAddressesListIndex;
                }
            }
        }
        if ((message = sendEmailRequest.getMessage()) != null) {
            Body body;
            Content subject = message.getSubject();
            if (subject != null) {
                if (subject.getData() != null) {
                    request.addParameter("Message.Subject.Data", StringUtils.fromString(subject.getData()));
                }
                if (subject.getCharset() != null) {
                    request.addParameter("Message.Subject.Charset", StringUtils.fromString(subject.getCharset()));
                }
            }
            if ((body = message.getBody()) != null) {
                Content html;
                Content text = body.getText();
                if (text != null) {
                    if (text.getData() != null) {
                        request.addParameter("Message.Body.Text.Data", StringUtils.fromString(text.getData()));
                    }
                    if (text.getCharset() != null) {
                        request.addParameter("Message.Body.Text.Charset", StringUtils.fromString(text.getCharset()));
                    }
                }
                if ((html = body.getHtml()) != null) {
                    if (html.getData() != null) {
                        request.addParameter("Message.Body.Html.Data", StringUtils.fromString(html.getData()));
                    }
                    if (html.getCharset() != null) {
                        request.addParameter("Message.Body.Html.Charset", StringUtils.fromString(html.getCharset()));
                    }
                }
            }
        }
        if (!sendEmailRequest.getReplyToAddresses().isEmpty() || !((SdkInternalList)sendEmailRequest.getReplyToAddresses()).isAutoConstruct()) {
            SdkInternalList replyToAddressesList = (SdkInternalList)sendEmailRequest.getReplyToAddresses();
            int replyToAddressesListIndex = 1;
            for (String replyToAddressesListValue : replyToAddressesList) {
                if (replyToAddressesListValue != null) {
                    request.addParameter("ReplyToAddresses.member." + replyToAddressesListIndex, StringUtils.fromString(replyToAddressesListValue));
                }
                ++replyToAddressesListIndex;
            }
        }
        if (sendEmailRequest.getReturnPath() != null) {
            request.addParameter("ReturnPath", StringUtils.fromString(sendEmailRequest.getReturnPath()));
        }
        if (sendEmailRequest.getSourceArn() != null) {
            request.addParameter("SourceArn", StringUtils.fromString(sendEmailRequest.getSourceArn()));
        }
        if (sendEmailRequest.getReturnPathArn() != null) {
            request.addParameter("ReturnPathArn", StringUtils.fromString(sendEmailRequest.getReturnPathArn()));
        }
        if (!sendEmailRequest.getTags().isEmpty() || !((SdkInternalList)sendEmailRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)sendEmailRequest.getTags();
            int tagsListIndex = 1;
            for (MessageTag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getName() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Name", StringUtils.fromString(tagsListValue.getName()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        if (sendEmailRequest.getConfigurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringUtils.fromString(sendEmailRequest.getConfigurationSetName()));
        }
        return request;
    }
}

