/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.buffered;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.regions.Region;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.amazonaws.services.sqs.buffered.QueueBuffer;
import com.amazonaws.services.sqs.buffered.QueueBufferConfig;
import com.amazonaws.services.sqs.buffered.ResultConverter;
import com.amazonaws.services.sqs.model.AddPermissionRequest;
import com.amazonaws.services.sqs.model.AddPermissionResult;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchResult;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityResult;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.CreateQueueResult;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.DeleteMessageBatchResult;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.DeleteMessageResult;
import com.amazonaws.services.sqs.model.DeleteQueueRequest;
import com.amazonaws.services.sqs.model.DeleteQueueResult;
import com.amazonaws.services.sqs.model.GetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesResult;
import com.amazonaws.services.sqs.model.GetQueueUrlRequest;
import com.amazonaws.services.sqs.model.GetQueueUrlResult;
import com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesRequest;
import com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesResult;
import com.amazonaws.services.sqs.model.ListQueueTagsRequest;
import com.amazonaws.services.sqs.model.ListQueueTagsResult;
import com.amazonaws.services.sqs.model.ListQueuesRequest;
import com.amazonaws.services.sqs.model.ListQueuesResult;
import com.amazonaws.services.sqs.model.PurgeQueueRequest;
import com.amazonaws.services.sqs.model.PurgeQueueResult;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.RemovePermissionRequest;
import com.amazonaws.services.sqs.model.RemovePermissionResult;
import com.amazonaws.services.sqs.model.SendMessageBatchRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.SendMessageBatchResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import com.amazonaws.services.sqs.model.SetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.SetQueueAttributesResult;
import com.amazonaws.services.sqs.model.TagQueueRequest;
import com.amazonaws.services.sqs.model.TagQueueResult;
import com.amazonaws.services.sqs.model.UntagQueueRequest;
import com.amazonaws.services.sqs.model.UntagQueueResult;
import com.amazonaws.util.VersionInfoUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

public class AmazonSQSBufferedAsyncClient
implements AmazonSQSAsync {
    public static final String USER_AGENT = AmazonSQSBufferedAsyncClient.class.getSimpleName() + "/" + VersionInfoUtils.getVersion();
    private final CachingMap buffers = new CachingMap(16, 0.75f, true);
    private final AmazonSQSAsync realSQS;
    private final QueueBufferConfig bufferConfigExemplar;

    public AmazonSQSBufferedAsyncClient(AmazonSQSAsync paramRealSQS) {
        this(paramRealSQS, new QueueBufferConfig());
    }

    public AmazonSQSBufferedAsyncClient(AmazonSQSAsync paramRealSQS, QueueBufferConfig config) {
        config.validate();
        this.realSQS = paramRealSQS;
        this.bufferConfigExemplar = config;
    }

    @Override
    public void setRegion(Region region) throws IllegalArgumentException {
        this.realSQS.setRegion(region);
    }

    @Override
    public SetQueueAttributesResult setQueueAttributes(SetQueueAttributesRequest setQueueAttributesRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(setQueueAttributesRequest, USER_AGENT);
        return this.realSQS.setQueueAttributes(setQueueAttributesRequest);
    }

    @Override
    public ChangeMessageVisibilityBatchResult changeMessageVisibilityBatch(ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(changeMessageVisibilityBatchRequest, USER_AGENT);
        return this.realSQS.changeMessageVisibilityBatch(changeMessageVisibilityBatchRequest);
    }

    @Override
    public ChangeMessageVisibilityResult changeMessageVisibility(ChangeMessageVisibilityRequest changeMessageVisibilityRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(changeMessageVisibilityRequest, USER_AGENT);
        QueueBuffer buffer = this.getQBuffer(changeMessageVisibilityRequest.getQueueUrl());
        return buffer.changeMessageVisibilitySync(changeMessageVisibilityRequest);
    }

    @Override
    public SendMessageBatchResult sendMessageBatch(SendMessageBatchRequest sendMessageBatchRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(sendMessageBatchRequest, USER_AGENT);
        return this.realSQS.sendMessageBatch(sendMessageBatchRequest);
    }

    @Override
    public SendMessageResult sendMessage(SendMessageRequest sendMessageRequest) throws AmazonServiceException, AmazonClientException {
        QueueBuffer buffer = this.getQBuffer(sendMessageRequest.getQueueUrl());
        ResultConverter.appendUserAgent(sendMessageRequest, USER_AGENT);
        return buffer.sendMessageSync(sendMessageRequest);
    }

    @Override
    public ReceiveMessageResult receiveMessage(ReceiveMessageRequest receiveMessageRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(receiveMessageRequest, USER_AGENT);
        QueueBuffer buffer = this.getQBuffer(receiveMessageRequest.getQueueUrl());
        return buffer.receiveMessageSync(receiveMessageRequest);
    }

    @Override
    public DeleteMessageBatchResult deleteMessageBatch(DeleteMessageBatchRequest deleteMessageBatchRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(deleteMessageBatchRequest, USER_AGENT);
        QueueBuffer buffer = this.getQBuffer(deleteMessageBatchRequest.getQueueUrl());
        return buffer.deleteMessageBatchSync(deleteMessageBatchRequest);
    }

    @Override
    public DeleteMessageResult deleteMessage(DeleteMessageRequest deleteMessageRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(deleteMessageRequest, USER_AGENT);
        QueueBuffer buffer = this.getQBuffer(deleteMessageRequest.getQueueUrl());
        return buffer.deleteMessageSync(deleteMessageRequest);
    }

    @Override
    public void shutdown() {
        for (QueueBuffer buffer : this.buffers.values()) {
            buffer.shutdown();
        }
        this.realSQS.shutdown();
    }

    public void flush() {
        for (QueueBuffer buffer : this.buffers.values()) {
            buffer.flush();
        }
    }

    @Override
    public Future<ChangeMessageVisibilityBatchResult> changeMessageVisibilityBatchAsync(ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(changeMessageVisibilityBatchRequest, USER_AGENT);
        return this.realSQS.changeMessageVisibilityBatchAsync(changeMessageVisibilityBatchRequest);
    }

    @Override
    public Future<ChangeMessageVisibilityResult> changeMessageVisibilityAsync(ChangeMessageVisibilityRequest changeMessageVisibilityRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(changeMessageVisibilityRequest, USER_AGENT);
        QueueBuffer buffer = this.getQBuffer(changeMessageVisibilityRequest.getQueueUrl());
        return buffer.changeMessageVisibility(changeMessageVisibilityRequest, null);
    }

    @Override
    public Future<SendMessageBatchResult> sendMessageBatchAsync(SendMessageBatchRequest sendMessageBatchRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(sendMessageBatchRequest, USER_AGENT);
        return this.realSQS.sendMessageBatchAsync(sendMessageBatchRequest);
    }

    @Override
    public Future<SendMessageResult> sendMessageAsync(SendMessageRequest sendMessageRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(sendMessageRequest, USER_AGENT);
        QueueBuffer buffer = this.getQBuffer(sendMessageRequest.getQueueUrl());
        return buffer.sendMessage(sendMessageRequest, null);
    }

    @Override
    public Future<ReceiveMessageResult> receiveMessageAsync(ReceiveMessageRequest receiveMessageRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(receiveMessageRequest, USER_AGENT);
        QueueBuffer buffer = this.getQBuffer(receiveMessageRequest.getQueueUrl());
        return buffer.receiveMessage(receiveMessageRequest, null);
    }

    @Override
    public Future<DeleteMessageBatchResult> deleteMessageBatchAsync(DeleteMessageBatchRequest deleteMessageBatchRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(deleteMessageBatchRequest, USER_AGENT);
        return this.realSQS.deleteMessageBatchAsync(deleteMessageBatchRequest);
    }

    @Override
    public void setEndpoint(String endpoint) throws IllegalArgumentException {
        this.realSQS.setEndpoint(endpoint);
    }

    @Override
    public Future<SetQueueAttributesResult> setQueueAttributesAsync(SetQueueAttributesRequest setQueueAttributesRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(setQueueAttributesRequest, USER_AGENT);
        return this.realSQS.setQueueAttributesAsync(setQueueAttributesRequest);
    }

    @Override
    public Future<GetQueueUrlResult> getQueueUrlAsync(GetQueueUrlRequest getQueueUrlRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(getQueueUrlRequest, USER_AGENT);
        return this.realSQS.getQueueUrlAsync(getQueueUrlRequest);
    }

    @Override
    public Future<RemovePermissionResult> removePermissionAsync(RemovePermissionRequest removePermissionRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(removePermissionRequest, USER_AGENT);
        return this.realSQS.removePermissionAsync(removePermissionRequest);
    }

    @Override
    public GetQueueUrlResult getQueueUrl(GetQueueUrlRequest getQueueUrlRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(getQueueUrlRequest, USER_AGENT);
        return this.realSQS.getQueueUrl(getQueueUrlRequest);
    }

    @Override
    public RemovePermissionResult removePermission(RemovePermissionRequest removePermissionRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(removePermissionRequest, USER_AGENT);
        return this.realSQS.removePermission(removePermissionRequest);
    }

    @Override
    public Future<GetQueueAttributesResult> getQueueAttributesAsync(GetQueueAttributesRequest getQueueAttributesRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(getQueueAttributesRequest, USER_AGENT);
        return this.realSQS.getQueueAttributesAsync(getQueueAttributesRequest);
    }

    @Override
    public GetQueueAttributesResult getQueueAttributes(GetQueueAttributesRequest getQueueAttributesRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(getQueueAttributesRequest, USER_AGENT);
        return this.realSQS.getQueueAttributes(getQueueAttributesRequest);
    }

    @Override
    public Future<PurgeQueueResult> purgeQueueAsync(PurgeQueueRequest purgeQueueRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(purgeQueueRequest, USER_AGENT);
        return this.realSQS.purgeQueueAsync(purgeQueueRequest);
    }

    @Override
    public PurgeQueueResult purgeQueue(PurgeQueueRequest purgeQueueRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(purgeQueueRequest, USER_AGENT);
        return this.realSQS.purgeQueue(purgeQueueRequest);
    }

    @Override
    public Future<DeleteQueueResult> deleteQueueAsync(DeleteQueueRequest deleteQueueRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(deleteQueueRequest, USER_AGENT);
        return this.realSQS.deleteQueueAsync(deleteQueueRequest);
    }

    @Override
    public DeleteQueueResult deleteQueue(DeleteQueueRequest deleteQueueRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(deleteQueueRequest, USER_AGENT);
        return this.realSQS.deleteQueue(deleteQueueRequest);
    }

    @Override
    public Future<ListQueuesResult> listQueuesAsync(ListQueuesRequest listQueuesRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(listQueuesRequest, USER_AGENT);
        return this.realSQS.listQueuesAsync(listQueuesRequest);
    }

    @Override
    public ListQueuesResult listQueues(ListQueuesRequest listQueuesRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(listQueuesRequest, USER_AGENT);
        return this.realSQS.listQueues(listQueuesRequest);
    }

    @Override
    public Future<CreateQueueResult> createQueueAsync(CreateQueueRequest createQueueRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(createQueueRequest, USER_AGENT);
        return this.realSQS.createQueueAsync(createQueueRequest);
    }

    @Override
    public CreateQueueResult createQueue(CreateQueueRequest createQueueRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(createQueueRequest, USER_AGENT);
        return this.realSQS.createQueue(createQueueRequest);
    }

    @Override
    public Future<AddPermissionResult> addPermissionAsync(AddPermissionRequest addPermissionRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(addPermissionRequest, USER_AGENT);
        return this.realSQS.addPermissionAsync(addPermissionRequest);
    }

    @Override
    public Future<AddPermissionResult> addPermissionAsync(String queueUrl, String label, List<String> aWSAccountIds, List<String> actions) {
        return this.addPermissionAsync(new AddPermissionRequest(queueUrl, label, aWSAccountIds, actions));
    }

    @Override
    public Future<AddPermissionResult> addPermissionAsync(String queueUrl, String label, List<String> aWSAccountIds, List<String> actions, AsyncHandler<AddPermissionRequest, AddPermissionResult> asyncHandler) {
        return this.addPermissionAsync(new AddPermissionRequest(queueUrl, label, aWSAccountIds, actions), asyncHandler);
    }

    @Override
    public AddPermissionResult addPermission(AddPermissionRequest addPermissionRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(addPermissionRequest, USER_AGENT);
        return this.realSQS.addPermission(addPermissionRequest);
    }

    @Override
    public ListQueuesResult listQueues() throws AmazonServiceException, AmazonClientException {
        return this.realSQS.listQueues();
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        ResultConverter.appendUserAgent(request, USER_AGENT);
        return this.realSQS.getCachedResponseMetadata(request);
    }

    @Override
    public Future<DeleteMessageResult> deleteMessageAsync(DeleteMessageRequest deleteMessageRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(deleteMessageRequest, USER_AGENT);
        QueueBuffer buffer = this.getQBuffer(deleteMessageRequest.getQueueUrl());
        return buffer.deleteMessage(deleteMessageRequest, null);
    }

    private synchronized QueueBuffer getQBuffer(String qUrl) {
        QueueBuffer toReturn = (QueueBuffer)this.buffers.get(qUrl);
        if (null == toReturn) {
            QueueBufferConfig config = new QueueBufferConfig(this.bufferConfigExemplar);
            toReturn = new QueueBuffer(config, qUrl, this.realSQS);
            this.buffers.put(qUrl, toReturn);
        }
        return toReturn;
    }

    @Override
    public Future<ChangeMessageVisibilityResult> changeMessageVisibilityAsync(ChangeMessageVisibilityRequest changeMessageVisibilityRequest, AsyncHandler<ChangeMessageVisibilityRequest, ChangeMessageVisibilityResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(changeMessageVisibilityRequest, USER_AGENT);
        QueueBuffer buffer = this.getQBuffer(changeMessageVisibilityRequest.getQueueUrl());
        return buffer.changeMessageVisibility(changeMessageVisibilityRequest, asyncHandler);
    }

    @Override
    public Future<ChangeMessageVisibilityResult> changeMessageVisibilityAsync(String queueUrl, String receiptHandle, Integer visibilityTimeout) {
        return this.changeMessageVisibilityAsync(new ChangeMessageVisibilityRequest(queueUrl, receiptHandle, visibilityTimeout));
    }

    @Override
    public Future<ChangeMessageVisibilityResult> changeMessageVisibilityAsync(String queueUrl, String receiptHandle, Integer visibilityTimeout, AsyncHandler<ChangeMessageVisibilityRequest, ChangeMessageVisibilityResult> asyncHandler) {
        return this.changeMessageVisibilityAsync(new ChangeMessageVisibilityRequest(queueUrl, receiptHandle, visibilityTimeout), asyncHandler);
    }

    @Override
    public Future<SendMessageResult> sendMessageAsync(SendMessageRequest sendMessageRequest, AsyncHandler<SendMessageRequest, SendMessageResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(sendMessageRequest, USER_AGENT);
        QueueBuffer buffer = this.getQBuffer(sendMessageRequest.getQueueUrl());
        return buffer.sendMessage(sendMessageRequest, asyncHandler);
    }

    @Override
    public Future<SendMessageResult> sendMessageAsync(String queueUrl, String messageBody) {
        return this.sendMessageAsync(new SendMessageRequest(queueUrl, messageBody));
    }

    @Override
    public Future<SendMessageResult> sendMessageAsync(String queueUrl, String messageBody, AsyncHandler<SendMessageRequest, SendMessageResult> asyncHandler) {
        return this.sendMessageAsync(new SendMessageRequest(queueUrl, messageBody), asyncHandler);
    }

    @Override
    public Future<ReceiveMessageResult> receiveMessageAsync(ReceiveMessageRequest receiveMessageRequest, AsyncHandler<ReceiveMessageRequest, ReceiveMessageResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(receiveMessageRequest, USER_AGENT);
        QueueBuffer buffer = this.getQBuffer(receiveMessageRequest.getQueueUrl());
        return buffer.receiveMessage(receiveMessageRequest, asyncHandler);
    }

    @Override
    public Future<ReceiveMessageResult> receiveMessageAsync(String queueUrl) {
        return this.receiveMessageAsync(new ReceiveMessageRequest(queueUrl));
    }

    @Override
    public Future<ReceiveMessageResult> receiveMessageAsync(String queueUrl, AsyncHandler<ReceiveMessageRequest, ReceiveMessageResult> asyncHandler) {
        return this.receiveMessageAsync(new ReceiveMessageRequest(queueUrl), asyncHandler);
    }

    @Override
    public Future<DeleteMessageResult> deleteMessageAsync(DeleteMessageRequest deleteMessageRequest, AsyncHandler<DeleteMessageRequest, DeleteMessageResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(deleteMessageRequest, USER_AGENT);
        QueueBuffer buffer = this.getQBuffer(deleteMessageRequest.getQueueUrl());
        return buffer.deleteMessage(deleteMessageRequest, asyncHandler);
    }

    @Override
    public Future<DeleteMessageResult> deleteMessageAsync(String queueUrl, String receiptHandle) {
        return this.deleteMessageAsync(new DeleteMessageRequest(queueUrl, receiptHandle));
    }

    @Override
    public Future<DeleteMessageResult> deleteMessageAsync(String queueUrl, String receiptHandle, AsyncHandler<DeleteMessageRequest, DeleteMessageResult> asyncHandler) {
        return this.deleteMessageAsync(new DeleteMessageRequest(queueUrl, receiptHandle), asyncHandler);
    }

    @Override
    public Future<SetQueueAttributesResult> setQueueAttributesAsync(SetQueueAttributesRequest setQueueAttributesRequest, AsyncHandler<SetQueueAttributesRequest, SetQueueAttributesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.realSQS.setQueueAttributesAsync(setQueueAttributesRequest, asyncHandler);
    }

    @Override
    public Future<SetQueueAttributesResult> setQueueAttributesAsync(String queueUrl, Map<String, String> attributes) throws AmazonServiceException, AmazonClientException {
        return this.realSQS.setQueueAttributesAsync(queueUrl, attributes);
    }

    @Override
    public Future<SetQueueAttributesResult> setQueueAttributesAsync(String queueUrl, Map<String, String> attributes, AsyncHandler<SetQueueAttributesRequest, SetQueueAttributesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.realSQS.setQueueAttributesAsync(queueUrl, attributes, asyncHandler);
    }

    @Override
    public Future<ChangeMessageVisibilityBatchResult> changeMessageVisibilityBatchAsync(ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest, AsyncHandler<ChangeMessageVisibilityBatchRequest, ChangeMessageVisibilityBatchResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.realSQS.changeMessageVisibilityBatchAsync(changeMessageVisibilityBatchRequest, asyncHandler);
    }

    @Override
    public Future<ChangeMessageVisibilityBatchResult> changeMessageVisibilityBatchAsync(String queueUrl, List<ChangeMessageVisibilityBatchRequestEntry> entries2) {
        return this.changeMessageVisibilityBatchAsync(new ChangeMessageVisibilityBatchRequest(queueUrl, entries2));
    }

    @Override
    public Future<ChangeMessageVisibilityBatchResult> changeMessageVisibilityBatchAsync(String queueUrl, List<ChangeMessageVisibilityBatchRequestEntry> entries2, AsyncHandler<ChangeMessageVisibilityBatchRequest, ChangeMessageVisibilityBatchResult> asyncHandler) {
        return this.changeMessageVisibilityBatchAsync(new ChangeMessageVisibilityBatchRequest(queueUrl, entries2), asyncHandler);
    }

    @Override
    public Future<GetQueueUrlResult> getQueueUrlAsync(GetQueueUrlRequest getQueueUrlRequest, AsyncHandler<GetQueueUrlRequest, GetQueueUrlResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.realSQS.getQueueUrlAsync(getQueueUrlRequest, asyncHandler);
    }

    @Override
    public Future<GetQueueUrlResult> getQueueUrlAsync(String queueName) {
        return this.getQueueUrlAsync(new GetQueueUrlRequest(queueName));
    }

    @Override
    public Future<GetQueueUrlResult> getQueueUrlAsync(String queueName, AsyncHandler<GetQueueUrlRequest, GetQueueUrlResult> asyncHandler) {
        return this.getQueueUrlAsync(new GetQueueUrlRequest(queueName), asyncHandler);
    }

    @Override
    public Future<RemovePermissionResult> removePermissionAsync(RemovePermissionRequest removePermissionRequest, AsyncHandler<RemovePermissionRequest, RemovePermissionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.realSQS.removePermissionAsync(removePermissionRequest, asyncHandler);
    }

    @Override
    public Future<RemovePermissionResult> removePermissionAsync(String queueUrl, String label) {
        return this.removePermissionAsync(new RemovePermissionRequest(queueUrl, label));
    }

    @Override
    public Future<RemovePermissionResult> removePermissionAsync(String queueUrl, String label, AsyncHandler<RemovePermissionRequest, RemovePermissionResult> asyncHandler) {
        return this.removePermissionAsync(new RemovePermissionRequest(queueUrl, label), asyncHandler);
    }

    @Override
    public Future<GetQueueAttributesResult> getQueueAttributesAsync(GetQueueAttributesRequest getQueueAttributesRequest, AsyncHandler<GetQueueAttributesRequest, GetQueueAttributesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.realSQS.getQueueAttributesAsync(getQueueAttributesRequest, asyncHandler);
    }

    @Override
    public Future<GetQueueAttributesResult> getQueueAttributesAsync(String queueUrl, List<String> attributeNames) {
        return this.getQueueAttributesAsync(new GetQueueAttributesRequest(queueUrl, attributeNames));
    }

    @Override
    public Future<GetQueueAttributesResult> getQueueAttributesAsync(String queueUrl, List<String> attributeNames, AsyncHandler<GetQueueAttributesRequest, GetQueueAttributesResult> asyncHandler) {
        return this.getQueueAttributesAsync(new GetQueueAttributesRequest(queueUrl, attributeNames), asyncHandler);
    }

    @Override
    public Future<SendMessageBatchResult> sendMessageBatchAsync(SendMessageBatchRequest sendMessageBatchRequest, AsyncHandler<SendMessageBatchRequest, SendMessageBatchResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.realSQS.sendMessageBatchAsync(sendMessageBatchRequest, asyncHandler);
    }

    @Override
    public Future<SendMessageBatchResult> sendMessageBatchAsync(String queueUrl, List<SendMessageBatchRequestEntry> entries2) {
        return this.sendMessageBatchAsync(new SendMessageBatchRequest(queueUrl, entries2));
    }

    @Override
    public Future<SendMessageBatchResult> sendMessageBatchAsync(String queueUrl, List<SendMessageBatchRequestEntry> entries2, AsyncHandler<SendMessageBatchRequest, SendMessageBatchResult> asyncHandler) {
        return this.sendMessageBatchAsync(new SendMessageBatchRequest(queueUrl, entries2), asyncHandler);
    }

    @Override
    public Future<PurgeQueueResult> purgeQueueAsync(PurgeQueueRequest purgeQueueRequest, AsyncHandler<PurgeQueueRequest, PurgeQueueResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.realSQS.purgeQueueAsync(purgeQueueRequest, asyncHandler);
    }

    @Override
    public Future<DeleteQueueResult> deleteQueueAsync(DeleteQueueRequest deleteQueueRequest, AsyncHandler<DeleteQueueRequest, DeleteQueueResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.realSQS.deleteQueueAsync(deleteQueueRequest, asyncHandler);
    }

    @Override
    public Future<DeleteQueueResult> deleteQueueAsync(String queueUrl) {
        return this.deleteQueueAsync(new DeleteQueueRequest(queueUrl));
    }

    @Override
    public Future<DeleteQueueResult> deleteQueueAsync(String queueUrl, AsyncHandler<DeleteQueueRequest, DeleteQueueResult> asyncHandler) {
        return this.deleteQueueAsync(new DeleteQueueRequest(queueUrl), asyncHandler);
    }

    @Override
    public Future<ListQueuesResult> listQueuesAsync(ListQueuesRequest listQueuesRequest, AsyncHandler<ListQueuesRequest, ListQueuesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.realSQS.listQueuesAsync(listQueuesRequest, asyncHandler);
    }

    @Override
    public Future<ListQueuesResult> listQueuesAsync() {
        return this.listQueuesAsync(new ListQueuesRequest());
    }

    @Override
    public Future<ListQueuesResult> listQueuesAsync(AsyncHandler<ListQueuesRequest, ListQueuesResult> asyncHandler) {
        return this.listQueuesAsync(new ListQueuesRequest(), asyncHandler);
    }

    @Override
    public Future<ListQueuesResult> listQueuesAsync(String queueNamePrefix) {
        return this.listQueuesAsync(new ListQueuesRequest(queueNamePrefix));
    }

    @Override
    public Future<ListQueuesResult> listQueuesAsync(String queueNamePrefix, AsyncHandler<ListQueuesRequest, ListQueuesResult> asyncHandler) {
        return this.listQueuesAsync(new ListQueuesRequest(queueNamePrefix), asyncHandler);
    }

    @Override
    public Future<DeleteMessageBatchResult> deleteMessageBatchAsync(DeleteMessageBatchRequest deleteMessageBatchRequest, AsyncHandler<DeleteMessageBatchRequest, DeleteMessageBatchResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.realSQS.deleteMessageBatchAsync(deleteMessageBatchRequest, asyncHandler);
    }

    @Override
    public Future<DeleteMessageBatchResult> deleteMessageBatchAsync(String queueUrl, List<DeleteMessageBatchRequestEntry> entries2) {
        return this.deleteMessageBatchAsync(new DeleteMessageBatchRequest(queueUrl, entries2));
    }

    @Override
    public Future<DeleteMessageBatchResult> deleteMessageBatchAsync(String queueUrl, List<DeleteMessageBatchRequestEntry> entries2, AsyncHandler<DeleteMessageBatchRequest, DeleteMessageBatchResult> asyncHandler) {
        return this.deleteMessageBatchAsync(new DeleteMessageBatchRequest(queueUrl, entries2), asyncHandler);
    }

    @Override
    public Future<CreateQueueResult> createQueueAsync(CreateQueueRequest createQueueRequest, AsyncHandler<CreateQueueRequest, CreateQueueResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.realSQS.createQueueAsync(createQueueRequest, asyncHandler);
    }

    @Override
    public Future<CreateQueueResult> createQueueAsync(String queueName) {
        return this.createQueueAsync(new CreateQueueRequest(queueName));
    }

    @Override
    public Future<CreateQueueResult> createQueueAsync(String queueName, AsyncHandler<CreateQueueRequest, CreateQueueResult> asyncHandler) {
        return this.createQueueAsync(new CreateQueueRequest(queueName), asyncHandler);
    }

    @Override
    public Future<AddPermissionResult> addPermissionAsync(AddPermissionRequest addPermissionRequest, AsyncHandler<AddPermissionRequest, AddPermissionResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.realSQS.addPermissionAsync(addPermissionRequest, asyncHandler);
    }

    @Override
    public ListDeadLetterSourceQueuesResult listDeadLetterSourceQueues(ListDeadLetterSourceQueuesRequest listDeadLetterSourceQueuesRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(listDeadLetterSourceQueuesRequest, USER_AGENT);
        return this.realSQS.listDeadLetterSourceQueues(listDeadLetterSourceQueuesRequest);
    }

    @Override
    public Future<ListDeadLetterSourceQueuesResult> listDeadLetterSourceQueuesAsync(ListDeadLetterSourceQueuesRequest listDeadLetterSourceQueuesRequest) throws AmazonServiceException, AmazonClientException {
        ResultConverter.appendUserAgent(listDeadLetterSourceQueuesRequest, USER_AGENT);
        return this.realSQS.listDeadLetterSourceQueuesAsync(listDeadLetterSourceQueuesRequest);
    }

    @Override
    public Future<ListDeadLetterSourceQueuesResult> listDeadLetterSourceQueuesAsync(ListDeadLetterSourceQueuesRequest listDeadLetterSourceQueuesRequest, AsyncHandler<ListDeadLetterSourceQueuesRequest, ListDeadLetterSourceQueuesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.realSQS.listDeadLetterSourceQueuesAsync(listDeadLetterSourceQueuesRequest, asyncHandler);
    }

    @Override
    public SetQueueAttributesResult setQueueAttributes(String queueUrl, Map<String, String> attributes) throws AmazonServiceException, AmazonClientException {
        return this.setQueueAttributes(new SetQueueAttributesRequest(queueUrl, attributes));
    }

    @Override
    public ChangeMessageVisibilityBatchResult changeMessageVisibilityBatch(String queueUrl, List<ChangeMessageVisibilityBatchRequestEntry> entries2) throws AmazonServiceException, AmazonClientException {
        return this.changeMessageVisibilityBatch(new ChangeMessageVisibilityBatchRequest(queueUrl, entries2));
    }

    @Override
    public ChangeMessageVisibilityResult changeMessageVisibility(String queueUrl, String receiptHandle, Integer visibilityTimeout) throws AmazonServiceException, AmazonClientException {
        return this.changeMessageVisibility(new ChangeMessageVisibilityRequest(queueUrl, receiptHandle, visibilityTimeout));
    }

    @Override
    public GetQueueUrlResult getQueueUrl(String queueName) throws AmazonServiceException, AmazonClientException {
        return this.getQueueUrl(new GetQueueUrlRequest(queueName));
    }

    @Override
    public RemovePermissionResult removePermission(String queueUrl, String label) throws AmazonServiceException, AmazonClientException {
        return this.removePermission(new RemovePermissionRequest(queueUrl, label));
    }

    @Override
    public SendMessageBatchResult sendMessageBatch(String queueUrl, List<SendMessageBatchRequestEntry> entries2) throws AmazonServiceException, AmazonClientException {
        return this.sendMessageBatch(new SendMessageBatchRequest(queueUrl, entries2));
    }

    @Override
    public DeleteQueueResult deleteQueue(String queueUrl) throws AmazonServiceException, AmazonClientException {
        return this.deleteQueue(new DeleteQueueRequest(queueUrl));
    }

    @Override
    public SendMessageResult sendMessage(String queueUrl, String messageBody) throws AmazonServiceException, AmazonClientException {
        return this.sendMessage(new SendMessageRequest(queueUrl, messageBody));
    }

    @Override
    public ReceiveMessageResult receiveMessage(String queueUrl) throws AmazonServiceException, AmazonClientException {
        return this.receiveMessage(new ReceiveMessageRequest(queueUrl));
    }

    @Override
    public ListQueuesResult listQueues(String queueNamePrefix) throws AmazonServiceException, AmazonClientException {
        return this.listQueues(new ListQueuesRequest(queueNamePrefix));
    }

    @Override
    public DeleteMessageBatchResult deleteMessageBatch(String queueUrl, List<DeleteMessageBatchRequestEntry> entries2) throws AmazonServiceException, AmazonClientException {
        return this.deleteMessageBatch(new DeleteMessageBatchRequest(queueUrl, entries2));
    }

    @Override
    public CreateQueueResult createQueue(String queueName) throws AmazonServiceException, AmazonClientException {
        return this.createQueue(new CreateQueueRequest(queueName));
    }

    @Override
    public AddPermissionResult addPermission(String queueUrl, String label, List<String> aWSAccountIds, List<String> actions) throws AmazonServiceException, AmazonClientException {
        return this.addPermission(new AddPermissionRequest(queueUrl, label, aWSAccountIds, actions));
    }

    @Override
    public DeleteMessageResult deleteMessage(String queueUrl, String receiptHandle) throws AmazonServiceException, AmazonClientException {
        return this.deleteMessage(new DeleteMessageRequest(queueUrl, receiptHandle));
    }

    @Override
    public GetQueueAttributesResult getQueueAttributes(String queueUrl, List<String> attributeNames) {
        return this.getQueueAttributes(new GetQueueAttributesRequest(queueUrl, attributeNames));
    }

    @Override
    public TagQueueResult tagQueue(TagQueueRequest tagQueueRequest) {
        ResultConverter.appendUserAgent(tagQueueRequest, USER_AGENT);
        return this.realSQS.tagQueue(tagQueueRequest);
    }

    @Override
    public TagQueueResult tagQueue(String queueUrl, Map<String, String> tags) {
        return this.tagQueue(new TagQueueRequest(queueUrl, tags));
    }

    @Override
    public Future<TagQueueResult> tagQueueAsync(TagQueueRequest tagQueueRequest) {
        ResultConverter.appendUserAgent(tagQueueRequest, USER_AGENT);
        return this.realSQS.tagQueueAsync(tagQueueRequest);
    }

    @Override
    public Future<TagQueueResult> tagQueueAsync(TagQueueRequest tagQueueRequest, AsyncHandler<TagQueueRequest, TagQueueResult> asyncHandler) {
        ResultConverter.appendUserAgent(tagQueueRequest, USER_AGENT);
        return this.realSQS.tagQueueAsync(tagQueueRequest, asyncHandler);
    }

    @Override
    public Future<TagQueueResult> tagQueueAsync(String queueUrl, Map<String, String> tags) {
        return this.tagQueueAsync(new TagQueueRequest(queueUrl, tags));
    }

    @Override
    public Future<TagQueueResult> tagQueueAsync(String queueUrl, Map<String, String> tags, AsyncHandler<TagQueueRequest, TagQueueResult> asyncHandler) {
        return this.tagQueueAsync(new TagQueueRequest(queueUrl, tags), asyncHandler);
    }

    @Override
    public UntagQueueResult untagQueue(UntagQueueRequest untagQueueRequest) {
        ResultConverter.appendUserAgent(untagQueueRequest, USER_AGENT);
        return this.realSQS.untagQueue(untagQueueRequest);
    }

    @Override
    public UntagQueueResult untagQueue(String queueUrl, List<String> tagKeys) {
        return this.untagQueue(new UntagQueueRequest(queueUrl, tagKeys));
    }

    @Override
    public Future<UntagQueueResult> untagQueueAsync(UntagQueueRequest untagQueueRequest) {
        ResultConverter.appendUserAgent(untagQueueRequest, USER_AGENT);
        return this.realSQS.untagQueueAsync(untagQueueRequest);
    }

    @Override
    public Future<UntagQueueResult> untagQueueAsync(UntagQueueRequest untagQueueRequest, AsyncHandler<UntagQueueRequest, UntagQueueResult> asyncHandler) {
        ResultConverter.appendUserAgent(untagQueueRequest, USER_AGENT);
        return this.realSQS.untagQueueAsync(untagQueueRequest, asyncHandler);
    }

    @Override
    public Future<UntagQueueResult> untagQueueAsync(String queueUrl, List<String> tagKeys) {
        return this.untagQueueAsync(new UntagQueueRequest(queueUrl, tagKeys));
    }

    @Override
    public Future<UntagQueueResult> untagQueueAsync(String queueUrl, List<String> tagKeys, AsyncHandler<UntagQueueRequest, UntagQueueResult> asyncHandler) {
        return this.untagQueueAsync(new UntagQueueRequest(queueUrl, tagKeys), asyncHandler);
    }

    @Override
    public ListQueueTagsResult listQueueTags(ListQueueTagsRequest listQueueTagsRequest) {
        ResultConverter.appendUserAgent(listQueueTagsRequest, USER_AGENT);
        return this.realSQS.listQueueTags(listQueueTagsRequest);
    }

    @Override
    public ListQueueTagsResult listQueueTags(String queueUrl) {
        return this.listQueueTags(new ListQueueTagsRequest(queueUrl));
    }

    @Override
    public Future<ListQueueTagsResult> listQueueTagsAsync(ListQueueTagsRequest listQueueTagsRequest) {
        ResultConverter.appendUserAgent(listQueueTagsRequest, USER_AGENT);
        return this.realSQS.listQueueTagsAsync(listQueueTagsRequest);
    }

    @Override
    public Future<ListQueueTagsResult> listQueueTagsAsync(ListQueueTagsRequest listQueueTagsRequest, AsyncHandler<ListQueueTagsRequest, ListQueueTagsResult> asyncHandler) {
        return this.realSQS.listQueueTagsAsync(listQueueTagsRequest, asyncHandler);
    }

    @Override
    public Future<ListQueueTagsResult> listQueueTagsAsync(String queueUrl) {
        return this.listQueueTagsAsync(new ListQueueTagsRequest(queueUrl));
    }

    @Override
    public Future<ListQueueTagsResult> listQueueTagsAsync(String queueUrl, AsyncHandler<ListQueueTagsRequest, ListQueueTagsResult> asyncHandler) {
        return this.listQueueTagsAsync(new ListQueueTagsRequest(queueUrl), asyncHandler);
    }

    class CachingMap
    extends LinkedHashMap<String, QueueBuffer> {
        private static final long serialVersionUID = 1L;
        private static final int MAX_ENTRIES = 100;

        public CachingMap(int initial, float loadFactor, boolean accessOrder) {
            super(initial, loadFactor, accessOrder);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, QueueBuffer> eldest) {
            return this.size() > 100;
        }
    }
}

