/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.sqs.model.ListQueuesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListQueuesRequestMarshaller
implements Marshaller<Request<ListQueuesRequest>, ListQueuesRequest> {
    @Override
    public Request<ListQueuesRequest> marshall(ListQueuesRequest listQueuesRequest) {
        if (listQueuesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListQueuesRequest> request = new DefaultRequest<ListQueuesRequest>(listQueuesRequest, "AmazonSQS");
        request.addParameter("Action", "ListQueues");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (listQueuesRequest.getQueueNamePrefix() != null) {
            request.addParameter("QueueNamePrefix", StringUtils.fromString(listQueuesRequest.getQueueNamePrefix()));
        }
        if (listQueuesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(listQueuesRequest.getNextToken()));
        }
        if (listQueuesRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(listQueuesRequest.getMaxResults()));
        }
        return request;
    }
}

