/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.chunk.manifest;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.duracloud.chunk.manifest.ChunksManifestBean;
import org.duracloud.chunk.manifest.xml.ManifestDocumentBinding;
import org.duracloud.chunk.stream.KnownLengthInputStream;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunksManifest
extends ChunksManifestBean {
    private final Logger log = LoggerFactory.getLogger(ChunksManifest.class);
    public static final String SCHEMA_VERSION = "0.2";
    private int chunkIndex = -1;
    private static final String mimetype = "application/xml";
    public static final String chunkSuffix = ".dura-chunk-";
    public static final String manifestSuffix = ".dura-manifest";
    private static final int MAX_CHUNKS = 9999;

    public ChunksManifest(ChunksManifestBean bean) {
        this.setEntries(bean.getEntries());
        this.setHeader(bean.getHeader());
    }

    public ChunksManifest(String sourceContentId, String sourceMimetype, long sourceByteSize) {
        this.setEntries(new ArrayList<ChunksManifestBean.ManifestEntry>());
        this.setHeader(new ChunksManifestBean.ManifestHeader(sourceContentId, sourceMimetype, sourceByteSize));
    }

    public void setMD5OfSourceContent(String md5) {
        this.getHeader().setSourceMD5(md5);
    }

    public String getManifestId() {
        return this.getHeader().getSourceContentId() + manifestSuffix;
    }

    public String nextChunkId() {
        if (this.chunkIndex >= 9999) {
            throw new DuraCloudRuntimeException("Max chunks: 9999");
        }
        return this.getHeader().getSourceContentId() + chunkSuffix + this.nextChunkIndex();
    }

    private String nextChunkIndex() {
        return String.format("%1$04d", ++this.chunkIndex);
    }

    public void addEntry(String chunkId, String chunkMD5, long chunkSize) {
        this.getEntries().add(new ChunksManifestBean.ManifestEntry(chunkId, chunkMD5, this.parseIndex(chunkId), chunkSize));
    }

    public int parseIndex(String chunkId) {
        String prefix = this.getHeader().getSourceContentId() + chunkSuffix;
        String num = chunkId.substring(prefix.length());
        try {
            return Integer.parseInt(num);
        }
        catch (NumberFormatException e) {
            StringBuilder msg = new StringBuilder("ChunkId's must be");
            msg.append("formatted with trailing index: " + chunkId + ", ");
            msg.append(e.getMessage());
            this.log.error(msg.toString(), e);
            throw new DuraCloudRuntimeException(msg.toString(), e);
        }
    }

    public KnownLengthInputStream getBody() {
        String xml = ManifestDocumentBinding.createDocumentFrom(this);
        this.log.debug("Manifest body: '" + xml + "'");
        try {
            return new KnownLengthInputStream(xml);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getMimetype() {
        return mimetype;
    }
}

