/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.io.IOException;
import java.io.StringWriter;

public class JaxbJsonSerializer<T> {
    private Class type;
    private ObjectMapper mapper;

    public JaxbJsonSerializer(Class<T> type) {
        this.type = type;
        this.mapper = new ObjectMapper();
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
        JaxbAnnotationIntrospector introspector = new JaxbAnnotationIntrospector();
        this.mapper.getDeserializationConfig().withInsertedAnnotationIntrospector(introspector);
        this.mapper.getSerializationConfig().withInsertedAnnotationIntrospector(introspector);
    }

    public String serialize(T object) throws IOException {
        StringWriter writer = new StringWriter();
        this.mapper.writeValue(writer, object);
        return writer.toString();
    }

    public T deserialize(String json) throws IOException {
        return this.mapper.readValue(json, this.type);
    }
}

