/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.xml;

import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;

public class SchemaGenerator
extends SchemaOutputResolver {
    private File baseDir = new File("src/main/resources");
    private String fileName = null;

    public SchemaGenerator(String fileName) {
        this.fileName = fileName;
    }

    public SchemaGenerator(String fileName, File schemaDir) {
        this(fileName);
        if (null != schemaDir) {
            this.baseDir = schemaDir;
        }
    }

    public void generateSchema(Class ... classes) throws JAXBException, IOException {
        if (!this.baseDir.exists()) {
            this.baseDir.mkdirs();
        }
        JAXBContext context = JAXBContext.newInstance(classes);
        context.generateSchema(this);
    }

    @Override
    public Result createOutput(String namespaceUri, String defaultFileName) throws IOException {
        if (null == this.fileName) {
            this.fileName = defaultFileName;
        }
        return new StreamResult(new File(this.baseDir, this.fileName));
    }
}

