/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.retrieval.source;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.duracloud.client.ContentStore;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.common.model.ContentItem;
import org.duracloud.domain.Content;
import org.duracloud.error.ContentStoreException;
import org.duracloud.retrieval.mgmt.RetrievalListener;
import org.duracloud.retrieval.source.ContentStream;
import org.duracloud.retrieval.source.RetrievalSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuraStoreRetrievalSource
implements RetrievalSource {
    private final Logger logger = LoggerFactory.getLogger(DuraStoreRetrievalSource.class);
    protected ContentStore contentStore = null;
    protected Iterator<String> spaceIds = null;
    protected String currentSpaceId = null;
    protected Iterator<String> currentContentList = null;

    public DuraStoreRetrievalSource(ContentStore store, List<String> spaces, boolean allSpaces) {
        this.contentStore = store;
        if (allSpaces) {
            try {
                spaces = this.contentStore.getSpaces();
            }
            catch (ContentStoreException e) {
                throw new RuntimeException("Unable to acquire list of spaces");
            }
        }
        this.spaceIds = this.verifySpaceIds(spaces);
    }

    protected Iterator<String> verifySpaceIds(List<String> spaces) throws RuntimeException {
        Iterator<String> verifiedSpaceIds = null;
        if (spaces != null && spaces.size() > 0) {
            try {
                List<String> spaceList = this.contentStore.getSpaces();
                ArrayList<String> nonExistentSpaces = new ArrayList<String>();
                for (String space : spaces) {
                    if (spaceList.contains(space)) continue;
                    nonExistentSpaces.add(space);
                }
                if (!nonExistentSpaces.isEmpty()) {
                    String error = "The following provided spaces do not exist: " + StringUtils.join(nonExistentSpaces, ", ");
                    throw new DuraCloudRuntimeException(error);
                }
                verifiedSpaceIds = spaces.iterator();
            }
            catch (ContentStoreException cse) {
                throw new DuraCloudRuntimeException("Error retrieving spaces list", cse);
            }
        } else {
            throw new RuntimeException("Spaces list is empty, there is no content to retrieve");
        }
        return verifiedSpaceIds;
    }

    @Override
    public synchronized ContentItem getNextContentItem() {
        if (this.currentContentList != null && this.currentContentList.hasNext()) {
            return new ContentItem(this.currentSpaceId, this.currentContentList.next());
        }
        if (this.spaceIds.hasNext()) {
            this.getNextSpace();
            return this.getNextContentItem();
        }
        return null;
    }

    protected synchronized void getNextSpace() {
        if (this.spaceIds.hasNext()) {
            this.currentSpaceId = this.spaceIds.next();
            try {
                this.currentContentList = this.contentStore.getSpaceContents(this.currentSpaceId);
            }
            catch (ContentStoreException e) {
                this.logger.error("Unable to get contents of space: " + this.currentSpaceId + " due to error: " + e.getMessage());
                this.currentContentList = null;
            }
        }
    }

    @Override
    public Map<String, String> getSourceProperties(ContentItem contentItem) {
        try {
            Map<String, String> properties = this.contentStore.getContentProperties(contentItem.getSpaceId(), contentItem.getContentId());
            return properties;
        }
        catch (ContentStoreException e) {
            throw new RuntimeException("Unable to get checksum for " + contentItem.toString() + " due to: " + e.getMessage());
        }
    }

    @Override
    public String getSourceChecksum(ContentItem contentItem) {
        return this.getSourceProperties(contentItem).get("content-checksum");
    }

    @Override
    public ContentStream getSourceContent(ContentItem contentItem, RetrievalListener listener2) {
        Content content = this.doGetContent(contentItem, listener2);
        return new ContentStream(content.getStream(), content.getProperties());
    }

    protected Content doGetContent(ContentItem contentItem, RetrievalListener listener2) {
        try {
            return this.contentStore.getContent(contentItem.getSpaceId(), contentItem.getContentId());
        }
        catch (ContentStoreException e) {
            throw new RuntimeException("Unable to get content for " + contentItem.toString() + " due to: " + e.getMessage());
        }
    }
}

