/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.service.impl;

import java.util.HashMap;
import java.util.Map;
import org.duracloud.snapshot.db.model.Restoration;
import org.duracloud.snapshot.db.model.Snapshot;
import org.duracloud.snapshot.service.impl.BatchJobBuilder;
import org.duracloud.snapshot.service.impl.RestoreJobBuilder;
import org.duracloud.snapshot.service.impl.SnapshotJobBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BatchJobBuilderManager {
    private static Logger log = LoggerFactory.getLogger(BatchJobBuilderManager.class);
    private Map<Class, BatchJobBuilder> builders = new HashMap<Class, BatchJobBuilder>();

    @Autowired
    public BatchJobBuilderManager(SnapshotJobBuilder snapshot, RestoreJobBuilder restoration) {
        this.builders.put(Snapshot.class, snapshot);
        this.builders.put(Restoration.class, restoration);
    }

    public BatchJobBuilder getBuilder(Object entity) {
        BatchJobBuilder builder = this.builders.get(entity.getClass());
        if (builder == null) {
            throw new RuntimeException("No builder registered for " + entity.getClass());
        }
        log.debug("found {} for {}", (Object)builder, entity);
        return builder;
    }
}

