/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.service.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.duracloud.snapshot.service.impl.ContentProperties;
import org.duracloud.snapshot.service.impl.StepExecutionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.NonTransientResourceException;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;

public class ContentPropertiesFileReader
extends StepExecutionSupport
implements ItemReader<ContentProperties> {
    private final Logger log = LoggerFactory.getLogger(ContentPropertiesFileReader.class);
    private File propertiesFile;
    private JsonParser jParser;

    public ContentPropertiesFileReader(File propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    @Override
    public synchronized ContentProperties read() throws Exception, UnexpectedInputException, ParseException, NonTransientResourceException {
        if (this.jParser == null) {
            JsonFactory jfactory = new JsonFactory();
            this.jParser = jfactory.createJsonParser(this.propertiesFile);
            this.jParser.nextToken();
            int itemsRead = (int)this.getItemsRead();
            for (int i = 0; i < itemsRead; ++i) {
                this.doRead();
            }
        }
        return this.doRead();
    }

    private ContentProperties doRead() throws IOException {
        if (this.jParser.isClosed()) {
            return null;
        }
        try {
            if (this.jParser.nextToken() != JsonToken.END_ARRAY && this.jParser.getText() != null) {
                return this.parseNext(this.jParser);
            }
        }
        catch (Exception e) {
            String message = "Error parsing content properties file: " + e.getMessage();
            this.log.error(message, e);
            throw new ParseException(message, e);
        }
        this.jParser.close();
        return null;
    }

    private synchronized ContentProperties parseNext(JsonParser jParser) throws Exception {
        String contentId = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        while (jParser.nextToken() != JsonToken.END_OBJECT && jParser.getText() != null) {
            contentId = jParser.getCurrentName();
            jParser.nextToken();
            jParser.nextToken();
            while (jParser.nextToken() != JsonToken.END_OBJECT && jParser.getText() != null) {
                String key = jParser.getCurrentName();
                String value = jParser.getText();
                properties.put(key, value);
            }
        }
        return new ContentProperties(contentId, properties);
    }
}

