/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.service.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.duracloud.client.task.SnapshotTaskClient;
import org.duracloud.common.notification.NotificationManager;
import org.duracloud.common.notification.NotificationType;
import org.duracloud.common.util.DateUtil;
import org.duracloud.snapshot.db.ContentDirUtils;
import org.duracloud.snapshot.db.model.DuracloudEndPointConfig;
import org.duracloud.snapshot.db.model.Restoration;
import org.duracloud.snapshot.db.model.Snapshot;
import org.duracloud.snapshot.db.repo.RestoreRepo;
import org.duracloud.snapshot.dto.RestoreStatus;
import org.duracloud.snapshot.service.BridgeConfiguration;
import org.duracloud.snapshot.service.EventLog;
import org.duracloud.snapshot.service.SnapshotManager;
import org.duracloud.snapshot.service.impl.ExecutionListenerConfig;
import org.duracloud.snapshot.service.impl.RestoreJobParameterMarshaller;
import org.duracloud.snapshot.service.impl.SnapshotJobExecutionListener;
import org.duracloud.snapshot.service.impl.SnapshotTaskClientHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParameters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="restoreJobListener")
public class RestoreJobExecutionListener
implements JobExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(SnapshotJobExecutionListener.class);
    @Autowired
    private NotificationManager notificationManager;
    @Autowired
    private RestoreRepo restoreRepo;
    @Autowired
    private SnapshotTaskClientHelper snapshotTaskClientHelper;
    @Autowired
    private BridgeConfiguration bridgeConfig;
    @Autowired
    private SnapshotManager snapshotManager;
    @Autowired
    private EventLog eventLog;
    private ExecutionListenerConfig config;
    private Integer daysToExpire;

    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public void setRestorationRepo(RestoreRepo restoreRepo) {
        this.restoreRepo = restoreRepo;
    }

    public void setSnapshotTaskClientHelper(SnapshotTaskClientHelper snapshotTaskClientHelper) {
        this.snapshotTaskClientHelper = snapshotTaskClientHelper;
    }

    public void setBridgeConfig(BridgeConfiguration bridgeConfig) {
        this.bridgeConfig = bridgeConfig;
    }

    public void init(ExecutionListenerConfig config, int daysToExpire) {
        this.config = config;
        this.daysToExpire = daysToExpire;
    }

    @Override
    @Transactional
    public void beforeJob(JobExecution jobExecution) {
    }

    @Override
    @Transactional
    public void afterJob(JobExecution jobExecution) {
        JobParameters jobParams = jobExecution.getJobParameters();
        ExitStatus status = jobExecution.getExitStatus();
        String restorationId = RestoreJobParameterMarshaller.unmarshal(jobParams);
        Restoration restoration = this.restoreRepo.findByRestorationId(restorationId);
        String restorationPath = ContentDirUtils.getSourcePath(restoration.getRestorationId(), this.config.getContentRoot());
        log.debug("Completed restoration: {} with status: {}", (Object)restoration.getRestorationId(), (Object)status);
        Snapshot snapshot = restoration.getSnapshot();
        String snapshotId = snapshot.getName();
        String restoreId = restoration.getRestorationId();
        Date currentDate = new Date();
        if (ExitStatus.COMPLETED.getExitCode().equals(status.getExitCode())) {
            try {
                Date expirationDate = this.changeRestoreStatus(restoration, RestoreStatus.RESTORATION_COMPLETE, "Completed transfer to duracloud on: " + currentDate, currentDate);
                DuracloudEndPointConfig destination = restoration.getDestination();
                SnapshotTaskClient taskClient = this.getSnapshotTaskClient(destination);
                taskClient.completeRestore(destination.getSpaceId(), this.daysToExpire);
                String subject = "DuraCloud snapshot " + snapshotId + " has been restored!";
                Object message = "A DuraCloud snapshot restore has completed successfully:\n\n";
                String formattedExpDate = DateUtil.convertToStringShort(expirationDate.getTime());
                message = (String)message + "Snapshot Id: " + snapshotId + "\n";
                message = (String)message + "Restore Id: " + restoreId + "\n";
                message = (String)message + "Destination Host: " + destination.getHost() + "\n";
                message = (String)message + "Destination StoreId: " + destination.getStoreId() + "\n";
                message = (String)message + "Destination SpaceId: " + destination.getSpaceId() + "\n";
                message = (String)message + "\nThe restored content WILL EXPIRE IN " + this.daysToExpire + " days, on " + formattedExpDate + ". At that time, the contents of the space '" + destination.getSpaceId() + "' will be removed, and the space will be deleted.\n";
                String history = "[{'restore-action':'RESTORE_COMPLETED'},{'restore-id':'" + restoreId + "'},{'expiration-date':'" + formattedExpDate + "'}]";
                this.snapshotManager.updateHistory(snapshot, history);
                log.info("deleting restoration path " + restorationPath);
                try {
                    FileUtils.deleteDirectory(new File(restorationPath));
                }
                catch (IOException e) {
                    log.error("failed to delete restoration path = " + restorationPath + ": " + e.getMessage(), e);
                }
                ArrayList<String> emailAddresses = new ArrayList<String>(Arrays.asList(this.config.getDuracloudEmailAddresses()));
                emailAddresses.add(restoration.getUserEmail());
                this.sendEmail(subject, (String)message, emailAddresses.toArray(new String[0]));
            }
            catch (Exception e) {
                this.handleError(restoration, currentDate, snapshotId, restoreId, restorationPath, e.getMessage(), status);
            }
        } else {
            String errorMessage = "Expected status of (spring batch) restore job to be " + ExitStatus.COMPLETED + ", but it was " + status + ". Unable to complete restoration.";
            this.handleError(restoration, currentDate, snapshotId, restoreId, restorationPath, errorMessage, status);
        }
    }

    private void handleError(Restoration restoration, Date currentDate, String snapshotId, String restoreId, String restorationPath, String errorMessage, ExitStatus status) {
        this.changeRestoreStatus(restoration, RestoreStatus.ERROR, "Failed to transfer to duracloud on: " + currentDate, currentDate);
        String subject = "DuraCloud snapshot " + snapshotId + " restoration failed to complete";
        String message = "A DuraCloud snapshot restoration has failed to complete.\n\nrestore-id=" + restoreId + "\nsnapshot-id=" + snapshotId + "\nrestore-path=" + restorationPath + "\nspring-batch-exit-status-code=" + status.getExitCode() + "\nspring-batch-exit-status-description=" + status.getExitDescription() + "\nerror-message=" + errorMessage;
        this.sendEmail(subject, message, this.config.getDuracloudEmailAddresses());
    }

    private Date changeRestoreStatus(Restoration restoration, RestoreStatus status, String msg, Date currentDate) {
        log.info("Changing restore status to: " + status + " with message: " + msg);
        restoration.setStatus(status);
        restoration.setStatusText(msg);
        Date expirationDate = this.getExpirationDate(currentDate, this.daysToExpire);
        if (status.equals((Object)RestoreStatus.RESTORATION_COMPLETE)) {
            restoration.setEndDate(currentDate);
            restoration.setExpirationDate(expirationDate);
        }
        this.restoreRepo.save(restoration);
        this.eventLog.logRestoreUpdate(restoration);
        return expirationDate;
    }

    protected Date getExpirationDate(Date endDate, int daysToExpire) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(endDate);
        calendar.add(5, daysToExpire);
        return calendar.getTime();
    }

    private void sendEmail(String subject, String msg, String ... destinations) {
        this.notificationManager.sendNotification(NotificationType.EMAIL, subject, msg.toString(), destinations);
        log.info("sent email with subject=\"" + subject + "\" to " + StringUtils.join((Object[])destinations, ","));
    }

    private SnapshotTaskClient getSnapshotTaskClient(DuracloudEndPointConfig source) {
        return this.snapshotTaskClientHelper.create(source, this.bridgeConfig.getDuracloudUsername(), this.bridgeConfig.getDuracloudPassword());
    }
}

