/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.service.impl;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.duracloud.client.ContentStore;
import org.duracloud.common.notification.NotificationManager;
import org.duracloud.common.notification.NotificationType;
import org.duracloud.common.util.DateUtil;
import org.duracloud.snapshot.SnapshotException;
import org.duracloud.snapshot.SnapshotInProcessException;
import org.duracloud.snapshot.SnapshotNotFoundException;
import org.duracloud.snapshot.db.ContentDirUtils;
import org.duracloud.snapshot.db.model.DuracloudEndPointConfig;
import org.duracloud.snapshot.db.model.Restoration;
import org.duracloud.snapshot.db.model.Snapshot;
import org.duracloud.snapshot.db.repo.RestoreRepo;
import org.duracloud.snapshot.db.repo.SnapshotRepo;
import org.duracloud.snapshot.dto.RestoreStatus;
import org.duracloud.snapshot.dto.SnapshotStatus;
import org.duracloud.snapshot.service.BridgeConfiguration;
import org.duracloud.snapshot.service.EventLog;
import org.duracloud.snapshot.service.InvalidStateTransitionException;
import org.duracloud.snapshot.service.NoRestorationInProcessException;
import org.duracloud.snapshot.service.RestorationNotFoundException;
import org.duracloud.snapshot.service.RestorationStateTransitionValidator;
import org.duracloud.snapshot.service.RestoreManager;
import org.duracloud.snapshot.service.RestoreManagerConfig;
import org.duracloud.snapshot.service.SnapshotJobManager;
import org.duracloud.snapshot.service.SnapshotManager;
import org.duracloud.snapshot.service.impl.StoreClientHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class RestoreManagerImpl
implements RestoreManager {
    private static Logger log = LoggerFactory.getLogger(RestoreManagerImpl.class);
    private RestoreManagerConfig config;
    private SnapshotJobManager jobManager;
    @Autowired
    private NotificationManager notificationManager;
    @Autowired
    private RestoreRepo restoreRepo;
    @Autowired
    private SnapshotRepo snapshotRepo;
    @Autowired
    private StoreClientHelper storeClientHelper;
    @Autowired
    private BridgeConfiguration bridgeConfig;
    @Autowired
    private SnapshotManager snapshotManager;
    @Autowired
    private EventLog eventLog;

    protected void setSnapshotRepo(SnapshotRepo snapshotRepo) {
        this.snapshotRepo = snapshotRepo;
    }

    protected void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    protected void setRestoreRepo(RestoreRepo restoreRepo) {
        this.restoreRepo = restoreRepo;
    }

    protected void setStoreClientHelper(StoreClientHelper storeClientHelper) {
        this.storeClientHelper = storeClientHelper;
    }

    protected void setEventLog(EventLog eventLog) {
        this.eventLog = eventLog;
    }

    protected void setBridgeConfig(BridgeConfiguration bridgeConfig) {
        this.bridgeConfig = bridgeConfig;
    }

    protected void setSnapshotManager(SnapshotManager snapshotManager) {
        this.snapshotManager = snapshotManager;
    }

    @Override
    public Restoration restoreSnapshot(String snapshotId, DuracloudEndPointConfig destination, String userEmail) throws SnapshotNotFoundException, SnapshotInProcessException, SnapshotException {
        this.checkInitialized();
        Snapshot snapshot = this.getSnapshot(snapshotId);
        if (!snapshot.getStatus().equals((Object)SnapshotStatus.SNAPSHOT_COMPLETE)) {
            throw new SnapshotInProcessException("Snapshot is not complete. Restoration can only occur on a completed snapshot.");
        }
        Restoration restoration = this.createRestoration(snapshot, destination, userEmail);
        this.validateAndSet(restoration, RestoreStatus.RETRIEVING_FROM_STORAGE, "Restoration request issued");
        restoration = this.save(restoration);
        String restorationId = restoration.getRestorationId();
        File restoreDir = this.getRestoreDir(restorationId);
        restoreDir.mkdirs();
        String subject = "Snapshot Restoration Request for Snapshot ID = " + snapshotId;
        String body = "Please perform a snapshot restore.\n\nSnapshot ID: " + snapshotId + "\nRestore ID: " + restorationId + "\nRestore Location: " + restoreDir.getAbsolutePath();
        this.notificationManager.sendNotification(NotificationType.EMAIL, subject, body, this.getAllEMailAddresses(this.config));
        return restoration;
    }

    @Override
    public Snapshot requestRestoreSnapshot(String snapshotId, DuracloudEndPointConfig destination, String userEmail) throws SnapshotException {
        this.checkInitialized();
        Snapshot snapshot = this.getSnapshot(snapshotId);
        String host = destination.getHost();
        String port = "" + destination.getPort();
        String storeId = destination.getStoreId();
        String url = "http" + (port.endsWith("443") ? "s" : "") + "://" + host + ":" + port + "/duradmin/spaces/sm/" + storeId + "/" + snapshotId + "?snapshot=true";
        String subject = "Snapshot Restoration Request for Snapshot ID = " + snapshotId;
        String format = "Please initiate a snapshot restore via the duracloud interface ( {0} ).\n\nSnapshot ID: {1}\nHost:{2}\nPort: {3}\nStore ID: {4}\nRequestor email: {5}";
        String body = MessageFormat.format(format, url, snapshotId, host, port, storeId, userEmail);
        String[] duracloudEmailAddresses = this.config.getDuracloudEmailAddresses();
        this.notificationManager.sendNotification(NotificationType.EMAIL, subject, body, duracloudEmailAddresses);
        log.info("sent email to {}: message body = {}", (Object)duracloudEmailAddresses, (Object)body);
        return snapshot;
    }

    private Restoration save(Restoration restoration) {
        Restoration saved = this.restoreRepo.saveAndFlush(restoration);
        this.eventLog.logRestoreUpdate(restoration);
        log.debug("saved {}", (Object)saved);
        return saved;
    }

    private Snapshot getSnapshot(String snapshotId) throws SnapshotNotFoundException {
        Snapshot snapshot = this.snapshotRepo.findByName(snapshotId);
        if (snapshot == null) {
            throw new SnapshotNotFoundException(snapshotId);
        }
        return snapshot;
    }

    private Restoration createRestoration(Snapshot snapshot, DuracloudEndPointConfig destination, String userEmail) throws SnapshotException {
        Restoration restoration = new Restoration();
        restoration.setDestination(destination);
        restoration.setSnapshot(snapshot);
        restoration.setUserEmail(userEmail);
        restoration.setStartDate(new Date());
        String restoreStartDate = DateUtil.convertToStringPlain(restoration.getStartDate().getTime());
        DuracloudEndPointConfig source = snapshot.getSource();
        String accountId = this.extractAccountId(source.getHost());
        String restorationId = accountId + "_" + source.getStoreId() + "_" + source.getSpaceId() + "_" + restoreStartDate;
        restoration.setRestorationId(restorationId);
        return restoration;
    }

    protected String extractAccountId(String host) {
        String accountId = host.split("[.]")[0];
        return accountId;
    }

    private String[] getAllEMailAddresses(RestoreManagerConfig config) {
        ArrayList<String> allAddresses = new ArrayList<String>();
        allAddresses.addAll(Arrays.asList(config.getDuracloudEmailAddresses()));
        allAddresses.addAll(Arrays.asList(config.getTargetStoreEmailAddresses()));
        return allAddresses.toArray(new String[allAddresses.size()]);
    }

    public Restoration getRestoration(String restorationId) throws RestorationNotFoundException {
        Restoration restoration = this.restoreRepo.findByRestorationId(restorationId);
        if (restoration == null) {
            throw new RestorationNotFoundException(restorationId);
        }
        return restoration;
    }

    private File getRestoreDir(String restorationId) {
        File restoreDir = new File(this.getRestorationContentDir(restorationId));
        return restoreDir;
    }

    @Override
    public Restoration restoreCompleted(String restorationId) throws SnapshotNotFoundException, SnapshotInProcessException, NoRestorationInProcessException, SnapshotException {
        Restoration restoration = this.getRestoration(restorationId);
        return this.restoreCompleted(restoration);
    }

    private Restoration restoreCompleted(Restoration restoration) throws InvalidStateTransitionException, RestorationNotFoundException, SnapshotException {
        RestoreStatus status = restoration.getStatus();
        final String restoreId = restoration.getRestorationId();
        if (status.equals((Object)RestoreStatus.STORAGE_RETRIEVAL_COMPLETE)) {
            log.warn("restoration {} already completed. Ignoring...", (Object)restoration);
            return restoration;
        }
        if (status.equals((Object)RestoreStatus.RETRIEVING_FROM_STORAGE)) {
            log.info("caller has indicated that restoration request {} is complete.", (Object)restoration);
            Restoration updatedRestoration = this._transitionRestoreStatus(RestoreStatus.STORAGE_RETRIEVAL_COMPLETE, "Completed restore to bridge storage", restoration);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        RestoreManagerImpl.this.jobManager.executeRestoration(restoreId);
                    }
                    catch (Exception ex) {
                        log.error("failed to restart restore: " + restoreId + ": message=" + ex.getMessage(), ex);
                    }
                }
            }).start();
            return updatedRestoration;
        }
        String message = "restore status type " + status + " not recognized. (restorationId = " + restoreId + ")";
        log.error(message);
        throw new SnapshotException(message, null);
    }

    private void checkInitialized() throws SnapshotException {
        if (this.config == null) {
            throw new SnapshotException("The snapshot restoration manager has not been initialized.", null);
        }
    }

    @Override
    public void init(RestoreManagerConfig config, SnapshotJobManager jobManager) {
        this.config = config;
        this.jobManager = jobManager;
    }

    private String getRestorationContentDir(String restorationId) {
        return ContentDirUtils.getSourcePath(restorationId, new File(this.config.getRestorationRootDir()));
    }

    @Override
    public Restoration get(String restorationId) throws RestorationNotFoundException {
        Restoration restoration = this.restoreRepo.findByRestorationId(restorationId);
        if (restoration == null) {
            log.debug("Restoration returned null for {}. Throwing exception...", (Object)restorationId);
            throw new RestorationNotFoundException(restorationId);
        }
        log.debug("got restoration {}", (Object)restoration);
        return restoration;
    }

    @Override
    public Restoration getBySnapshotId(String snapshotId) throws RestorationNotFoundException {
        List<Restoration> restorations = this.restoreRepo.findBySnapshotNameOrderByModifiedDesc(snapshotId);
        if (CollectionUtils.isEmpty(restorations)) {
            log.debug("Restoration returned null for snapshot id {}. Throwing exception...", (Object)snapshotId);
            throw new RestorationNotFoundException("No restorations associated with snapshot " + snapshotId);
        }
        return restorations.get(0);
    }

    @Override
    @Transactional
    public Restoration transitionRestoreStatus(String restorationId, RestoreStatus status, String message) throws InvalidStateTransitionException, RestorationNotFoundException {
        Restoration restoration = this.getRestoration(restorationId);
        return this._transitionRestoreStatus(status, message, restoration);
    }

    private Restoration _transitionRestoreStatus(RestoreStatus status, String message, Restoration restoration) throws InvalidStateTransitionException {
        this.validateAndSet(restoration, status, message);
        restoration = this.save(restoration);
        log.debug("transitioned restore status to {} for {}", (Object)status, (Object)restoration);
        return restoration;
    }

    private void validateAndSet(Restoration restoration, RestoreStatus status, String message) throws InvalidStateTransitionException {
        RestorationStateTransitionValidator.validate(restoration.getStatus(), status);
        restoration.setStatus(status);
        restoration.setStatusText(message + " on: " + new Date());
    }

    @Override
    @Transactional
    public void finalizeRestores() {
        log.debug("Running finalize restores...");
        List<Restoration> completedRestores = this.restoreRepo.findByStatus(RestoreStatus.RESTORATION_COMPLETE);
        for (Restoration restoration : completedRestores) {
            Date expirationDate = restoration.getExpirationDate();
            if (!expirationDate.before(new Date())) continue;
            DuracloudEndPointConfig destination = restoration.getDestination();
            ContentStore store = this.storeClientHelper.create(destination, this.bridgeConfig.getDuracloudUsername(), this.bridgeConfig.getDuracloudPassword());
            try {
                String spaceId = destination.getSpaceId();
                Iterator<String> it = store.getSpaceContents(spaceId);
                if (it.hasNext()) continue;
                log.info("Deleting expired restoration space: " + spaceId + " at host: " + destination.getHost());
                store.deleteSpace(spaceId);
                this.validateAndSet(restoration, RestoreStatus.RESTORATION_EXPIRED, "Restoration expired");
                restoration = this.save(restoration);
                log.info("Transition of restore " + restoration.getRestorationId() + " to expired state completed successfully");
                String history = "[{'restore-action':'RESTORE_EXPIRED'},{'restore-id':'" + restoration.getRestorationId() + "'}]";
                this.snapshotManager.updateHistory(restoration.getSnapshot(), history);
            }
            catch (Exception e) {
                log.error("Failed to transition restore " + restoration.getRestorationId() + " to expired state due to: " + e.getMessage());
            }
        }
    }

    @Override
    @Transactional
    public void cancelRestore(String restoreId) throws SnapshotException {
        this.jobManager.cancelRestore(restoreId);
        this.restoreRepo.deleteByRestorationId(restoreId);
    }

    @Override
    @Transactional
    public Restoration restartRestore(String restoreId) throws SnapshotException {
        Restoration restoration = this.jobManager.stopRestore(restoreId);
        restoration.setEndDate(null);
        restoration.setStatus(RestoreStatus.RETRIEVING_FROM_STORAGE);
        restoration = this.restoreRepo.save(restoration);
        this.eventLog.logRestoreUpdate(restoration);
        return this.restoreCompleted(restoration);
    }
}

