/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.snapshot.service.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.duracloud.client.ContentStore;
import org.duracloud.client.task.SnapshotTaskClient;
import org.duracloud.common.notification.NotificationManager;
import org.duracloud.common.notification.NotificationType;
import org.duracloud.common.retry.Retriable;
import org.duracloud.common.retry.Retrier;
import org.duracloud.common.util.ChecksumUtil;
import org.duracloud.common.util.IOUtil;
import org.duracloud.error.ContentStoreException;
import org.duracloud.error.NotFoundException;
import org.duracloud.snapshot.SnapshotException;
import org.duracloud.snapshot.SnapshotNotFoundException;
import org.duracloud.snapshot.db.ContentDirUtils;
import org.duracloud.snapshot.db.model.DuracloudEndPointConfig;
import org.duracloud.snapshot.db.model.Snapshot;
import org.duracloud.snapshot.db.model.SnapshotContentItem;
import org.duracloud.snapshot.db.model.SnapshotHistory;
import org.duracloud.snapshot.db.repo.SnapshotContentItemRepo;
import org.duracloud.snapshot.db.repo.SnapshotRepo;
import org.duracloud.snapshot.dto.SnapshotStatus;
import org.duracloud.snapshot.dto.task.CompleteSnapshotTaskResult;
import org.duracloud.snapshot.service.AlternateIdAlreadyExistsException;
import org.duracloud.snapshot.service.BridgeConfiguration;
import org.duracloud.snapshot.service.EventLog;
import org.duracloud.snapshot.service.SnapshotManager;
import org.duracloud.snapshot.service.SnapshotManagerException;
import org.duracloud.snapshot.service.impl.PropertiesSerializer;
import org.duracloud.snapshot.service.impl.SnapshotTaskClientHelper;
import org.duracloud.snapshot.service.impl.StoreClientHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class SnapshotManagerImpl
implements SnapshotManager {
    public static final int MAX_DAYS_IN_CLEANUP = 3;
    private static Logger log = LoggerFactory.getLogger(SnapshotManagerImpl.class);
    protected static String[] METADATA_FILENAMES = new String[]{".collection-snapshot.properties", "content-properties.json", "manifest-md5.txt", "manifest-sha256.txt"};
    private Map<String, Date> lastCleanupFailureNotificationBySnapshot = new HashMap<String, Date>();
    private long secondsBetweenCleanupFailureNotifications = 86400L;
    @Autowired
    private SnapshotContentItemRepo snapshotContentItemRepo;
    @Autowired
    private SnapshotRepo snapshotRepo;
    @Autowired
    private NotificationManager notificationManager;
    @Autowired
    private SnapshotTaskClientHelper snapshotTaskClientHelper;
    @Autowired
    private StoreClientHelper storeClientHelper;
    @Autowired
    private BridgeConfiguration bridgeConfig;
    @Autowired
    private EventLog eventLog;

    protected void setSnapshotContentItemRepo(SnapshotContentItemRepo snapshotContentItemRepo) {
        this.snapshotContentItemRepo = snapshotContentItemRepo;
    }

    protected void setSnapshotRepo(SnapshotRepo snapshotRepo) {
        this.snapshotRepo = snapshotRepo;
    }

    protected void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    protected void setSnapshotTaskClientHelper(SnapshotTaskClientHelper snapshotTaskClientHelper) {
        this.snapshotTaskClientHelper = snapshotTaskClientHelper;
    }

    protected void setBridgeConfig(BridgeConfiguration bridgeConfig) {
        this.bridgeConfig = bridgeConfig;
    }

    protected void setEventLog(EventLog eventLog) {
        this.eventLog = eventLog;
    }

    @Override
    @Transactional
    public void addContentItem(Snapshot snapshot, String contentId, Map<String, String> props) throws SnapshotException {
        String contentIdHash = this.createChecksumGenerator().generateChecksum(contentId);
        try {
            if (this.snapshotContentItemRepo.findBySnapshotAndContentIdHash(snapshot, contentIdHash) != null) {
                return;
            }
            SnapshotContentItem item = new SnapshotContentItem();
            item.setContentId(contentId);
            item.setSnapshot(snapshot);
            item.setContentIdHash(contentIdHash);
            String propString = PropertiesSerializer.serialize(props);
            item.setMetadata(propString);
            this.snapshotContentItemRepo.save(item);
        }
        catch (Exception ex) {
            throw new SnapshotException("failed to add content item: " + ex.getMessage(), ex);
        }
    }

    @Override
    @Transactional
    public Snapshot addAlternateSnapshotIds(Snapshot snapshot, List<String> alternateIds) throws AlternateIdAlreadyExistsException {
        snapshot = (Snapshot)this.snapshotRepo.findOne(snapshot.getId());
        for (String altId : alternateIds) {
            Snapshot altSnapshot = this.snapshotRepo.findBySnapshotAlternateIds(altId);
            if (altSnapshot == null || altSnapshot.getName().equals(snapshot.getName())) continue;
            throw new AlternateIdAlreadyExistsException("The alternate snapshot id (" + altId + ") already exists in another snapshot (" + altSnapshot.getName() + ")");
        }
        snapshot.addSnapshotAlternateIds(alternateIds);
        return this.snapshotRepo.saveAndFlush(snapshot);
    }

    @Override
    @Transactional
    public Snapshot transferToStorageComplete(String snapshotId) throws SnapshotException {
        try {
            Snapshot snapshot = this.getSnapshot(snapshotId);
            snapshot = this.changeSnapshotStatus(snapshot, SnapshotStatus.CLEANING_UP, "");
            File snapshotDir = new File(ContentDirUtils.getDestinationPath(snapshot.getName(), BridgeConfiguration.getContentRootDir()));
            final File zipFile = this.zipMetadata(snapshotId, snapshotDir);
            DuracloudEndPointConfig source = snapshot.getSource();
            final ContentStore store = this.getContentStore(source);
            this.ensureMetadataSpaceExists(store);
            final String zipChecksum = this.createChecksumGenerator().generateChecksum(zipFile);
            try {
                new Retrier(4, 1000, 2).execute(new Retriable(){

                    @Override
                    public Object retry() throws Exception {
                        try (FileInputStream zipStream = new FileInputStream(zipFile);){
                            String string = store.addContent("x-snapshot-metadata", zipFile.getName(), zipStream, zipFile.length(), "application/zip", zipChecksum, null);
                            return string;
                        }
                    }
                });
            }
            catch (Exception ex) {
                log.error("failed to upload snapshot zip (" + zipFile.getAbsolutePath() + ") to duracloud: " + ex.getMessage(), ex);
                throw new Exception(ex);
            }
            finally {
                zipFile.delete();
            }
            FileUtils.deleteDirectory(snapshotDir);
            String spaceId = source.getSpaceId();
            this.getSnapshotTaskClient(source).cleanupSnapshot(spaceId);
            log.info("successfully initiated snapshot cleanup on DuraCloud for snapshotId = " + snapshotId + "; spaceId = " + spaceId);
            return snapshot;
        }
        catch (Exception e) {
            String message = "failed to initiate snapshot clean up: " + e.getMessage();
            log.error(message, e);
            throw new SnapshotManagerException(e.getMessage());
        }
    }

    private ChecksumUtil createChecksumGenerator() {
        return new ChecksumUtil(ChecksumUtil.Algorithm.MD5);
    }

    @Override
    @Transactional
    public Snapshot transferError(String snapshotId, String errorDetails) throws SnapshotException {
        try {
            Snapshot snapshot = this.getSnapshot(snapshotId);
            snapshot = this.changeSnapshotStatus(snapshot, SnapshotStatus.ERROR, errorDetails);
            String subject = "Snapshot ERROR: " + snapshotId;
            String message = "A snapshot process has been halted and set to the error state.\n\nSnapshot ID: " + snapshotId + "\nReported Error: " + errorDetails;
            String[] recipients = this.bridgeConfig.getDuracloudEmailAddresses();
            this.notificationManager.sendNotification(NotificationType.EMAIL, subject, message, recipients);
            log.info("successfully set snapshot " + snapshotId + " into error state based on the following error details: " + errorDetails);
            return snapshot;
        }
        catch (Exception e) {
            String message = "failed to set snapshot into error state due to: " + e.getMessage();
            log.error(message, e);
            throw new SnapshotManagerException(e.getMessage());
        }
    }

    private void ensureMetadataSpaceExists(ContentStore store) throws ContentStoreException {
        String spaceId = "x-snapshot-metadata";
        try {
            store.getSpace(spaceId, null, 0L, null);
        }
        catch (NotFoundException e) {
            store.createSpace(spaceId);
        }
    }

    private File zipMetadata(String snapshotId, File snapshotDir) throws FileNotFoundException, IOException {
        File zipFile = new File(snapshotDir, snapshotId + ".zip");
        FileOutputStream fileOutputStream = new FileOutputStream(zipFile);
        ZipOutputStream zipOs = new ZipOutputStream(fileOutputStream);
        for (String file : METADATA_FILENAMES) {
            IOUtil.addFileToZipOutputStream(new File(snapshotDir, file), zipOs);
        }
        zipOs.close();
        return zipFile;
    }

    private ContentStore getContentStore(DuracloudEndPointConfig source) {
        ContentStore store = this.storeClientHelper.create(source, this.bridgeConfig.getDuracloudUsername(), this.bridgeConfig.getDuracloudPassword());
        return store;
    }

    private SnapshotTaskClient getSnapshotTaskClient(DuracloudEndPointConfig source) {
        return this.snapshotTaskClientHelper.create(source, this.bridgeConfig.getDuracloudUsername(), this.bridgeConfig.getDuracloudPassword());
    }

    private Snapshot getSnapshot(String snapshotId) throws SnapshotException {
        Snapshot snapshot = this.snapshotRepo.findByName(snapshotId);
        if (snapshot == null) {
            throw new SnapshotNotFoundException("A snapshot with id " + snapshotId + " does not exist.");
        }
        return snapshot;
    }

    private Snapshot cleanupComplete(Snapshot snapshot) throws SnapshotException {
        snapshot.setEndDate(new Date());
        snapshot = this.changeSnapshotStatus(snapshot, SnapshotStatus.SNAPSHOT_COMPLETE, "");
        String snapshotId = snapshot.getName();
        String message = "Snapshot complete: " + snapshotId;
        ArrayList<String> recipients = new ArrayList<String>(Arrays.asList(this.bridgeConfig.getDuracloudEmailAddresses()));
        String userEmail = snapshot.getUserEmail();
        if (userEmail != null) {
            recipients.add(userEmail);
        }
        if (recipients.size() > 0) {
            this.notificationManager.sendNotification(NotificationType.EMAIL, message, message, recipients.toArray(new String[0]));
        }
        return snapshot;
    }

    @Override
    @Transactional
    public void finalizeSnapshots() {
        log.debug("Running finalize snapshots...");
        List<Snapshot> snapshots = this.snapshotRepo.findByStatusOrderBySnapshotDateAsc(SnapshotStatus.CLEANING_UP);
        for (Snapshot snapshot : snapshots) {
            DuracloudEndPointConfig source = snapshot.getSource();
            ContentStore store = this.getContentStore(source);
            String snapshotId = snapshot.getName();
            try {
                String spaceId = source.getSpaceId();
                Iterator<String> it = store.getSpaceContents(spaceId);
                if (!it.hasNext()) {
                    log.debug("notifying task provider that snapshot is complete for space " + spaceId);
                    CompleteSnapshotTaskResult result = this.getSnapshotTaskClient(source).completeSnapshot(spaceId);
                    log.info("snapshot complete call to task provider performed for space " + spaceId + ": result = " + result.getResult());
                    this.cleanupComplete(snapshot);
                    continue;
                }
                Calendar c = Calendar.getInstance();
                int maxDays = 3;
                c.add(5, -1 * maxDays);
                if (!snapshot.getModified().before(c.getTime())) continue;
                Date lastNotification = this.lastCleanupFailureNotificationBySnapshot.get(snapshotId);
                Date nextNotification = new Date();
                if (lastNotification != null) {
                    nextNotification = new Date(lastNotification.getTime() + this.secondsBetweenCleanupFailureNotifications * 1000L);
                }
                if (nextNotification.getTime() > System.currentTimeMillis()) continue;
                String subject = MessageFormat.format("Snapshot cleanup has not completed in over {0} days for snapshot: {1}", maxDays, snapshotId);
                String body = subject + "\n\nSnapshot object=>" + snapshot;
                Object[] recipients = this.bridgeConfig.getDuracloudEmailAddresses();
                log.warn(body + "  Sending notification to duracloud admins: {} ", recipients);
                if (recipients.length <= 0) continue;
                this.notificationManager.sendNotification(NotificationType.EMAIL, subject, body, (String[])recipients);
                this.lastCleanupFailureNotificationBySnapshot.put(snapshotId, new Date());
            }
            catch (Exception e) {
                log.error("failed to cleanup " + source);
            }
        }
    }

    @Override
    @Transactional
    public Snapshot updateHistory(Snapshot snapshot, String history) {
        snapshot = (Snapshot)this.snapshotRepo.getOne(snapshot.getId());
        SnapshotHistory newHistory = new SnapshotHistory();
        newHistory.setHistory(history);
        newHistory.setSnapshot(snapshot);
        snapshot.getSnapshotHistory().add(newHistory);
        return this.snapshotRepo.save(snapshot);
    }

    public void setStoreClientHelper(StoreClientHelper storeClientHelper) {
        this.storeClientHelper = storeClientHelper;
    }

    @Override
    @Transactional
    public void deleteSnapshot(String snapshotId) {
        this.snapshotContentItemRepo.deleteBySnapshotName(snapshotId);
        this.snapshotRepo.deleteByName(snapshotId);
        log.info("successfully deleted snapshot: {}", (Object)snapshotId);
    }

    public void setSecondsBetweenCleanupFailureNotifications(long secondsBetweenCleanupFailureNotifications) {
        this.secondsBetweenCleanupFailureNotifications = secondsBetweenCleanupFailureNotifications;
    }

    private Snapshot changeSnapshotStatus(Snapshot snapshot, SnapshotStatus status, String statusText) {
        snapshot.setStatus(status);
        snapshot.setStatusText(statusText);
        Snapshot savedSnapshot = this.snapshotRepo.saveAndFlush(snapshot);
        this.eventLog.logSnapshotUpdate(savedSnapshot);
        log.info("Updated status of " + snapshot + " to " + status);
        return savedSnapshot;
    }
}

