/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.storage.domain;

public enum StorageProviderType {
    AMAZON_S3("amazon-s3"),
    AMAZON_GLACIER("amazon-glacier"),
    SWIFT_S3("swift-s3"),
    CHRONOPOLIS("chronopolis"),
    UNKNOWN("unknown"),
    TEST_RETRY("test-retry"),
    TEST_VERIFY_CREATE("test-verify-create"),
    TEST_VERIFY_DELETE("test-verify-delete");

    private final String text;

    private StorageProviderType(String pt) {
        this.text = pt;
    }

    public static StorageProviderType fromString(String pt) {
        for (StorageProviderType pType : StorageProviderType.values()) {
            if (!pType.text.equalsIgnoreCase(pt) && !pType.name().equalsIgnoreCase(pt)) continue;
            return pType;
        }
        return UNKNOWN;
    }

    public String toString() {
        return this.text;
    }

    public String getName() {
        return this.name();
    }
}

