/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.sync.endpoint;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.event.EventListenerSupport;
import org.duracloud.client.ContentStore;
import org.duracloud.common.util.ContentIdUtil;
import org.duracloud.common.util.DateUtil;
import org.duracloud.error.ContentStoreException;
import org.duracloud.storage.util.StorageProviderUtil;
import org.duracloud.sync.endpoint.EndPointListener;
import org.duracloud.sync.endpoint.MonitoredFile;
import org.duracloud.sync.endpoint.MonitoredInputStream;
import org.duracloud.sync.endpoint.SyncEndpoint;
import org.duracloud.sync.endpoint.SyncResultType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuraStoreSyncEndpoint
implements SyncEndpoint {
    private final Logger logger = LoggerFactory.getLogger(DuraStoreSyncEndpoint.class);
    private ContentStore contentStore;
    private String username;
    private String spaceId;
    private boolean syncDeletes;
    private boolean syncUpdates;
    private boolean renameUpdates;
    private boolean jumpStart;
    private String updateSuffix;
    private String storeId;
    private String prefix;
    EventListenerSupport<EndPointListener> listenerList;

    public DuraStoreSyncEndpoint(ContentStore contentStore, String username, String spaceId, boolean syncDeletes, boolean syncUpdates, boolean renameUpdates, boolean jumpStart, String updateSuffix, String prefix) {
        this.contentStore = contentStore;
        this.username = username;
        this.storeId = this.contentStore.getStoreId();
        this.spaceId = spaceId;
        this.syncDeletes = syncDeletes;
        this.syncUpdates = syncUpdates;
        this.renameUpdates = renameUpdates;
        this.jumpStart = jumpStart;
        this.updateSuffix = updateSuffix;
        this.prefix = prefix;
        this.listenerList = new EventListenerSupport<EndPointListener>(EndPointListener.class);
        this.logger.info("Sync endpoint ready to transfer to space:" + spaceId + " in store: " + this.storeId + " with config:  syncDeletes:" + syncDeletes + ", syncUpdates:" + syncUpdates + ", renameUpdates:" + renameUpdates + ", jumpStart:" + jumpStart + ", updateSuffix:" + updateSuffix + ", prefix:" + prefix);
        this.ensureSpaceExists();
    }

    public DuraStoreSyncEndpoint(ContentStore contentStore, String username, String spaceId, boolean syncDeletes, boolean jumpStart) {
        this(contentStore, username, spaceId, syncDeletes, true, false, jumpStart, ".orig", null);
    }

    protected String getUsername() {
        return this.username;
    }

    private void ensureSpaceExists() {
        try {
            this.contentStore.getSpaceACLs(this.spaceId);
        }
        catch (ContentStoreException e) {
            throw new RuntimeException("Could not connect to space with ID '" + this.spaceId + "'.");
        }
    }

    @Override
    public boolean syncFile(MonitoredFile syncFile, File watchDir) {
        SyncResultType result = this.syncFileAndReturnDetailedResult(syncFile, watchDir);
        return result != SyncResultType.FAILED;
    }

    @Override
    public SyncResultType syncFileAndReturnDetailedResult(MonitoredFile syncFile, File watchDir) {
        SyncResultType result = SyncResultType.ALREADY_IN_SYNC;
        String contentId = ContentIdUtil.getContentId(syncFile.getFile(), watchDir, this.prefix);
        String absPath = syncFile.getAbsolutePath();
        this.logger.debug("Syncing file " + absPath + " to DuraCloud with ID " + contentId);
        try {
            boolean dcFileExists;
            if (this.jumpStart && syncFile.exists()) {
                this.doAddContent(syncFile, contentId, absPath);
                return SyncResultType.ADDED;
            }
            Map<String, String> contentProperties = this.getContentProperties(this.spaceId, contentId);
            boolean bl = dcFileExists = null != contentProperties;
            if (syncFile.exists()) {
                if (dcFileExists) {
                    String dcChecksum = contentProperties.get("content-checksum");
                    if (dcChecksum.equals(syncFile.getChecksum())) {
                        this.logger.debug("Checksum for local file {} matches file in DuraCloud, no update needed.", (Object)absPath);
                    } else if (this.syncUpdates) {
                        this.logger.debug("Local file {} changed, updating DuraCloud.", (Object)absPath);
                        if (this.renameUpdates) {
                            String timeStamp = DateUtil.nowPlain();
                            String backupContentId = contentId + this.updateSuffix + "." + timeStamp;
                            this.logger.info("Renaming {} to {} to prevent it from being overwritten", (Object)contentId, (Object)backupContentId);
                            this.contentStore.copyContent(this.spaceId, contentId, this.spaceId, backupContentId);
                            this.listenerList.fire().contentBackedUp(this.storeId, this.spaceId, contentId, backupContentId, absPath);
                        }
                        this.addUpdateContent(contentId, syncFile, absPath);
                        this.listenerList.fire().contentUpdated(this.storeId, this.spaceId, contentId, absPath);
                        result = SyncResultType.UPDATED;
                    } else {
                        this.logger.debug("Local file {} changed, but sync updates options ", (Object)absPath);
                        this.listenerList.fire().contentUpdateIgnored(this.storeId, this.spaceId, contentId, absPath);
                        result = SyncResultType.UPDATE_IGNORED;
                    }
                } else {
                    this.doAddContent(syncFile, contentId, absPath);
                    result = SyncResultType.ADDED;
                }
            } else if (this.syncDeletes) {
                String noPrefixContentId;
                if (dcFileExists) {
                    result = this.deleteContent(this.spaceId, contentId, absPath);
                } else if (null != this.prefix && null != this.getContentProperties(this.spaceId, noPrefixContentId = contentId.substring(this.prefix.length()))) {
                    result = this.deleteContent(this.spaceId, noPrefixContentId, absPath);
                }
            } else {
                this.logger.debug("Ignoring delete of file {}", (Object)absPath);
            }
        }
        catch (ContentStoreException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    protected void doAddContent(MonitoredFile syncFile, String contentId, String absPath) throws ContentStoreException {
        this.logger.debug("Local file {} added, moving to DuraCloud.", (Object)absPath);
        this.addUpdateContent(contentId, syncFile, syncFile.getAbsolutePath());
        this.listenerList.fire().contentAdded(this.storeId, this.spaceId, contentId, absPath);
    }

    protected Map<String, String> getContentProperties(String spaceId, String contentId) {
        Map<String, String> props = null;
        try {
            props = this.contentStore.getContentProperties(spaceId, contentId);
        }
        catch (ContentStoreException e) {
            this.logger.debug("Content properties do not exist for content item {} in space {}", (Object)contentId, (Object)spaceId);
        }
        return props;
    }

    private SyncResultType deleteContent(String spaceId, String contentId, String absPath) throws ContentStoreException {
        this.logger.debug("Local file {} deleted, removing from DuraCloud.", (Object)absPath);
        this.deleteContent(spaceId, contentId);
        return SyncResultType.DELETED;
    }

    @Override
    public void deleteContent(String spaceId, String contentId) throws ContentStoreException {
        this.logger.info("Deleting {} from DuraCloud space {}", (Object)contentId, (Object)spaceId);
        this.contentStore.deleteContent(spaceId, contentId);
        this.listenerList.fire().contentDeleted(this.storeId, this.spaceId, contentId);
    }

    private void addUpdateContent(String contentId, MonitoredFile syncFile, String absPath) throws ContentStoreException {
        this.logger.info("Adding local file {} to DuraCloud space {} with content ID {}", absPath, this.spaceId, contentId);
        this.addUpdateContent(contentId, syncFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addUpdateContent(String contentId, MonitoredFile syncFile) throws ContentStoreException {
        MonitoredInputStream syncStream = syncFile.getStream();
        Map<String, String> props = this.createProps(syncFile.getAbsolutePath(), this.username);
        try {
            this.contentStore.addContent(this.spaceId, contentId, syncStream, syncFile.length(), syncFile.getMimetype(), syncFile.getChecksum(), props);
        }
        finally {
            try {
                ((InputStream)syncStream).close();
            }
            catch (IOException e) {
                this.logger.error("Error attempting to close stream for file " + contentId + ": " + e.getMessage(), e);
            }
        }
    }

    protected Map<String, String> createProps(String absolutePath, String username) {
        Map<String, String> props = StorageProviderUtil.createContentProperties(absolutePath, username);
        this.removePropsWithNonUSASCIINamesOrValues(props);
        return props;
    }

    private void removePropsWithNonUSASCIINamesOrValues(Map<String, String> props) {
        for (String key : new ArrayList<String>(props.keySet())) {
            if (this.isAllUSASCII(key) && this.isAllUSASCII(props.get(key))) continue;
            props.remove(key);
        }
    }

    private boolean isAllUSASCII(String value) {
        if (value != null) {
            CharsetEncoder encoder = Charset.forName("US-ASCII").newEncoder();
            return encoder.canEncode(value);
        }
        return true;
    }

    @Override
    public Iterator<String> getFilesList() {
        Iterator<String> spaceContents;
        try {
            spaceContents = this.contentStore.getSpaceContents(this.spaceId);
        }
        catch (ContentStoreException e) {
            throw new RuntimeException("Unable to get list of files from DuraStore due to: " + e.getMessage());
        }
        return spaceContents;
    }

    protected ContentStore getContentStore() {
        return this.contentStore;
    }

    protected String getSpaceId() {
        return this.spaceId;
    }

    @Override
    public void addEndPointListener(EndPointListener listener2) {
        this.listenerList.addListener(listener2);
    }

    @Override
    public void removeEndPointListener(EndPointListener listener2) {
        this.listenerList.removeListener(listener2);
    }
}

