/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.sync.monitor;

import java.io.File;
import java.io.FileFilter;
import java.util.List;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.duracloud.sync.mgmt.SyncManager;
import org.duracloud.sync.monitor.DirectoryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryUpdateMonitor {
    private final Logger logger = LoggerFactory.getLogger(SyncManager.class);
    private FileAlterationMonitor monitor;

    public DirectoryUpdateMonitor(List<File> directories, long pollFrequency, boolean syncDeletes) {
        this.monitor = new FileAlterationMonitor(pollFrequency);
        for (File watchDir : directories) {
            if (watchDir.exists()) {
                FileAlterationObserver observer;
                if (watchDir.isDirectory()) {
                    observer = new FileAlterationObserver(watchDir);
                } else {
                    final File file = watchDir;
                    observer = new FileAlterationObserver(watchDir.getParentFile(), new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return file.equals(pathname);
                        }
                    });
                }
                observer.addListener(new DirectoryListener(syncDeletes));
                this.monitor.addObserver(observer);
                continue;
            }
            throw new RuntimeException("Path " + watchDir.getAbsolutePath() + " does not exist");
        }
    }

    public void startMonitor() {
        this.logger.info("Starting Directory Update Monitor");
        try {
            this.monitor.start();
        }
        catch (IllegalStateException e) {
            this.logger.info("File alteration monitor is already started: " + e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void stopMonitor() {
        this.logger.info("Stopping Directory Update Monitor");
        try {
            this.monitor.stop();
        }
        catch (IllegalStateException e) {
            this.logger.info("File alteration monitor is already stopped: " + e.getMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

