/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.parallel.set.sorted;

import org.eclipse.collections.api.annotation.Beta;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.impl.block.procedure.IfProcedure;
import org.eclipse.collections.impl.lazy.parallel.AbstractBatch;
import org.eclipse.collections.impl.lazy.parallel.list.ListBatch;
import org.eclipse.collections.impl.lazy.parallel.set.sorted.CollectSortedSetBatch;
import org.eclipse.collections.impl.lazy.parallel.set.sorted.FlatCollectSortedSetBatch;
import org.eclipse.collections.impl.lazy.parallel.set.sorted.SortedSetBatch;
import org.eclipse.collections.impl.map.mutable.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class SelectSortedSetBatch<T>
extends AbstractBatch<T>
implements SortedSetBatch<T> {
    private final SortedSetBatch<T> sortedSetBatch;
    private final Predicate<? super T> predicate;

    public SelectSortedSetBatch(SortedSetBatch<T> sortedSetBatch, Predicate<? super T> predicate) {
        this.sortedSetBatch = sortedSetBatch;
        this.predicate = predicate;
    }

    @Override
    public void forEach(Procedure<? super T> procedure) {
        this.sortedSetBatch.forEach(new IfProcedure<T>(this.predicate, procedure));
    }

    @Override
    public SortedSetBatch<T> select(Predicate<? super T> predicate) {
        return new SelectSortedSetBatch<T>(this, predicate);
    }

    @Override
    public <V> ListBatch<V> collect(Function<? super T, ? extends V> function) {
        return new CollectSortedSetBatch<T, V>(this, function);
    }

    @Override
    public <V> ListBatch<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return new FlatCollectSortedSetBatch(this, function);
    }

    @Override
    public SortedSetBatch<T> distinct(ConcurrentHashMap<T, Boolean> distinct2) {
        return this;
    }
}

