/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility.internal.primitive;

import java.util.Collection;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.iterator.ShortIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ShortIteratorIterate {
    private ShortIteratorIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static void forEach(ShortIterator iterator2, ShortProcedure procedure) {
        while (iterator2.hasNext()) {
            procedure.value(iterator2.next());
        }
    }

    public static <R extends MutableShortCollection> R select(ShortIterator iterator2, ShortPredicate predicate, R targetCollection) {
        while (iterator2.hasNext()) {
            short item = iterator2.next();
            if (!predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <R extends MutableShortCollection> R reject(ShortIterator iterator2, ShortPredicate predicate, R targetCollection) {
        while (iterator2.hasNext()) {
            short item = iterator2.next();
            if (predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <V, R extends Collection<V>> R collect(ShortIterator iterator2, ShortToObjectFunction<? extends V> function, R targetCollection) {
        while (iterator2.hasNext()) {
            short item = iterator2.next();
            targetCollection.add(function.valueOf(item));
        }
        return targetCollection;
    }

    public static short detectIfNone(ShortIterator iterator2, ShortPredicate predicate, short ifNone) {
        while (iterator2.hasNext()) {
            short item = iterator2.next();
            if (!predicate.accept(item)) continue;
            return item;
        }
        return ifNone;
    }

    public static int count(ShortIterator iterator2, ShortPredicate predicate) {
        int count2 = 0;
        while (iterator2.hasNext()) {
            if (!predicate.accept(iterator2.next())) continue;
            ++count2;
        }
        return count2;
    }

    public static boolean anySatisfy(ShortIterator iterator2, ShortPredicate predicate) {
        while (iterator2.hasNext()) {
            if (!predicate.accept(iterator2.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean allSatisfy(ShortIterator iterator2, ShortPredicate predicate) {
        while (iterator2.hasNext()) {
            if (predicate.accept(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean noneSatisfy(ShortIterator iterator2, ShortPredicate predicate) {
        while (iterator2.hasNext()) {
            if (!predicate.accept(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public static <T> T injectInto(ShortIterator iterator2, T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        while (iterator2.hasNext()) {
            result = function.valueOf(result, iterator2.next());
        }
        return result;
    }

    public static long sum(ShortIterator iterator2) {
        long sum2 = 0L;
        while (iterator2.hasNext()) {
            sum2 += (long)iterator2.next();
        }
        return sum2;
    }

    public static short max(ShortIterator iterator2) {
        short max2 = iterator2.next();
        while (iterator2.hasNext()) {
            short next = iterator2.next();
            if (max2 >= next) continue;
            max2 = next;
        }
        return max2;
    }

    public static short min(ShortIterator iterator2) {
        short min2 = iterator2.next();
        while (iterator2.hasNext()) {
            short next = iterator2.next();
            if (next >= min2) continue;
            min2 = next;
        }
        return min2;
    }
}

