/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.StaleObjectStateException;
import org.hibernate.dialect.lock.AbstractSelectLockingStrategy;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.sql.SimpleSelect;

public class SelectLockingStrategy
extends AbstractSelectLockingStrategy {
    public SelectLockingStrategy(Lockable lockable, LockMode lockMode) {
        super(lockable, lockMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock(Serializable id, Object version, Object object, int timeout, SharedSessionContractImplementor session) throws StaleObjectStateException, JDBCException {
        String sql = this.determineSql(timeout);
        SessionFactoryImplementor factory = session.getFactory();
        try {
            PreparedStatement st = session.getJdbcCoordinator().getStatementPreparer().prepareStatement(sql);
            try {
                this.getLockable().getIdentifierType().nullSafeSet(st, id, 1, session);
                if (this.getLockable().isVersioned()) {
                    this.getLockable().getVersionType().nullSafeSet(st, version, this.getLockable().getIdentifierType().getColumnSpan(factory) + 1, session);
                }
                ResultSet rs = session.getJdbcCoordinator().getResultSetReturn().extract(st);
                try {
                    if (!rs.next()) {
                        if (factory.getStatistics().isStatisticsEnabled()) {
                            factory.getStatistics().optimisticFailure(this.getLockable().getEntityName());
                        }
                        throw new StaleObjectStateException(this.getLockable().getEntityName(), id);
                    }
                }
                finally {
                    session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(rs, st);
                }
            }
            finally {
                session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(st);
                session.getJdbcCoordinator().afterStatementExecution();
            }
        }
        catch (SQLException sqle) {
            throw session.getJdbcServices().getSqlExceptionHelper().convert(sqle, "could not lock: " + MessageHelper.infoString((EntityPersister)this.getLockable(), id, session.getFactory()), sql);
        }
    }

    @Override
    protected String generateLockString(int timeout) {
        SessionFactoryImplementor factory = this.getLockable().getFactory();
        LockOptions lockOptions = new LockOptions(this.getLockMode());
        lockOptions.setTimeOut(timeout);
        SimpleSelect select2 = new SimpleSelect(factory.getDialect()).setLockOptions(lockOptions).setTableName(this.getLockable().getRootTableName()).addColumn(this.getLockable().getRootTableIdentifierColumnNames()[0]).addCondition(this.getLockable().getRootTableIdentifierColumnNames(), "=?");
        if (this.getLockable().isVersioned()) {
            select2.addCondition(this.getLockable().getVersionColumnName(), "=?");
        }
        if (factory.getSessionFactoryOptions().isCommentsEnabled()) {
            select2.setComment((Object)((Object)this.getLockMode()) + " lock " + this.getLockable().getEntityName());
        }
        return select2.toStatementString();
    }
}

