/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.PersistentObjectException;
import org.hibernate.TypeMismatchException;
import org.hibernate.action.internal.DelayedPostInsertIdentifier;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.loader.entity.CacheEntityLoaderHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.type.EmbeddedComponentType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class DefaultLoadEventListener
implements LoadEventListener {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DefaultLoadEventListener.class);

    @Override
    public void onLoad(LoadEvent event, LoadEventListener.LoadType loadType) throws HibernateException {
        EntityPersister persister = this.getPersister(event);
        if (persister == null) {
            throw new HibernateException("Unable to locate persister: " + event.getEntityClassName());
        }
        Class idClass = persister.getIdentifierType().getReturnedClass();
        if (idClass != null && !idClass.isInstance(event.getEntityId()) && !DelayedPostInsertIdentifier.class.isInstance(event.getEntityId())) {
            this.checkIdClass(persister, event, loadType, idClass);
        }
        this.doOnLoad(persister, event, loadType);
    }

    protected EntityPersister getPersister(LoadEvent event) {
        if (event.getInstanceToLoad() != null) {
            event.setEntityClassName(event.getInstanceToLoad().getClass().getName());
            return event.getSession().getEntityPersister(null, event.getInstanceToLoad());
        }
        return event.getSession().getFactory().getEntityPersister(event.getEntityClassName());
    }

    private void doOnLoad(EntityPersister persister, LoadEvent event, LoadEventListener.LoadType loadType) {
        try {
            EntityKey keyToLoad = event.getSession().generateEntityKey(event.getEntityId(), persister);
            if (loadType.isNakedEntityReturned()) {
                event.setResult(this.load(event, persister, keyToLoad, loadType));
            } else if (event.getLockMode() == LockMode.NONE) {
                event.setResult(this.proxyOrLoad(event, persister, keyToLoad, loadType));
            } else {
                event.setResult(this.lockAndLoad(event, persister, keyToLoad, loadType, event.getSession()));
            }
        }
        catch (HibernateException e) {
            LOG.unableToLoadCommand(e);
            throw e;
        }
    }

    private void checkIdClass(EntityPersister persister, LoadEvent event, LoadEventListener.LoadType loadType, Class idClass) {
        EntityType dependentParentType;
        Type dependentParentIdType;
        Type singleSubType;
        EmbeddedComponentType dependentIdType;
        if (persister.getEntityMetamodel().getIdentifierProperty().isEmbedded() && (dependentIdType = (EmbeddedComponentType)persister.getEntityMetamodel().getIdentifierProperty().getType()).getSubtypes().length == 1 && (singleSubType = dependentIdType.getSubtypes()[0]).isEntityType() && (dependentParentIdType = (dependentParentType = (EntityType)singleSubType).getIdentifierOrUniqueKeyType(event.getSession().getFactory())).getReturnedClass().isInstance(event.getEntityId())) {
            this.loadByDerivedIdentitySimplePkValue(event, loadType, persister, dependentIdType, event.getSession().getFactory().getEntityPersister(dependentParentType.getAssociatedEntityName()));
            return;
        }
        throw new TypeMismatchException("Provided id of the wrong type for class " + persister.getEntityName() + ". Expected: " + idClass + ", got " + event.getEntityId().getClass());
    }

    private void loadByDerivedIdentitySimplePkValue(LoadEvent event, LoadEventListener.LoadType options, EntityPersister dependentPersister, EmbeddedComponentType dependentIdType, EntityPersister parentPersister) {
        EntityKey parentEntityKey = event.getSession().generateEntityKey(event.getEntityId(), parentPersister);
        Object parent = this.doLoad(event, parentPersister, parentEntityKey, options);
        Serializable dependent = (Serializable)dependentIdType.instantiate(parent, event.getSession());
        dependentIdType.setPropertyValues(dependent, new Object[]{parent}, dependentPersister.getEntityMode());
        EntityKey dependentEntityKey = event.getSession().generateEntityKey(dependent, dependentPersister);
        event.setEntityId(dependent);
        event.setResult(this.doLoad(event, dependentPersister, dependentEntityKey, options));
    }

    private Object load(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) {
        boolean isOptionalInstance;
        if (event.getInstanceToLoad() != null) {
            if (event.getSession().getPersistenceContext().getEntry(event.getInstanceToLoad()) != null) {
                throw new PersistentObjectException("attempted to load into an instance that was already associated with the session: " + MessageHelper.infoString(persister, event.getEntityId(), event.getSession().getFactory()));
            }
            persister.setIdentifier(event.getInstanceToLoad(), event.getEntityId(), event.getSession());
        }
        Object entity = this.doLoad(event, persister, keyToLoad, options);
        boolean bl = isOptionalInstance = event.getInstanceToLoad() != null;
        if (entity == null && (!options.isAllowNulls() || isOptionalInstance)) {
            event.getSession().getFactory().getEntityNotFoundDelegate().handleEntityNotFound(event.getEntityClassName(), event.getEntityId());
        } else if (isOptionalInstance && entity != event.getInstanceToLoad()) {
            throw new NonUniqueObjectException(event.getEntityId(), event.getEntityClassName());
        }
        return entity;
    }

    private Object proxyOrLoad(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) {
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Loading entity: {0}", (Object)MessageHelper.infoString(persister, event.getEntityId(), event.getSession().getFactory()));
        }
        if (!persister.hasProxy()) {
            return this.load(event, persister, keyToLoad, options);
        }
        PersistenceContext persistenceContext = event.getSession().getPersistenceContext();
        Object proxy = persistenceContext.getProxy(keyToLoad);
        if (proxy != null) {
            return this.returnNarrowedProxy(event, persister, keyToLoad, options, persistenceContext, proxy);
        }
        if (options.isAllowProxyCreation()) {
            return this.createProxyIfNecessary(event, persister, keyToLoad, options, persistenceContext);
        }
        return this.load(event, persister, keyToLoad, options);
    }

    private Object returnNarrowedProxy(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options, PersistenceContext persistenceContext, Object proxy) {
        LazyInitializer li;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Entity proxy found in session cache");
        }
        if ((li = ((HibernateProxy)proxy).getHibernateLazyInitializer()).isUnwrap()) {
            return li.getImplementation();
        }
        Object impl = null;
        if (!options.isAllowProxyCreation() && (impl = this.load(event, persister, keyToLoad, options)) == null) {
            event.getSession().getFactory().getEntityNotFoundDelegate().handleEntityNotFound(persister.getEntityName(), keyToLoad.getIdentifier());
        }
        return persistenceContext.narrowProxy(proxy, persister, keyToLoad, impl);
    }

    private Object createProxyIfNecessary(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options, PersistenceContext persistenceContext) {
        Object existing = persistenceContext.getEntity(keyToLoad);
        if (existing != null) {
            EntityEntry entry;
            Status status;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Entity found in session cache");
            }
            if (options.isCheckDeleted() && ((status = (entry = persistenceContext.getEntry(existing)).getStatus()) == Status.DELETED || status == Status.GONE)) {
                return null;
            }
            return existing;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating new proxy for entity");
        }
        Object proxy = persister.createProxy(event.getEntityId(), event.getSession());
        persistenceContext.getBatchFetchQueue().addBatchLoadableEntityKey(keyToLoad);
        persistenceContext.addProxy(keyToLoad, proxy);
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object lockAndLoad(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options, SessionImplementor source) {
        Object entity;
        Object ck;
        SoftLock lock = null;
        EntityDataAccess cache = persister.getCacheAccessStrategy();
        if (persister.canWriteToCache()) {
            ck = cache.generateCacheKey(event.getEntityId(), persister, source.getFactory(), source.getTenantIdentifier());
            lock = persister.getCacheAccessStrategy().lockItem(source, ck, null);
        } else {
            ck = null;
        }
        try {
            entity = this.load(event, persister, keyToLoad, options);
            if (!persister.canWriteToCache()) return event.getSession().getPersistenceContext().proxyFor(persister, keyToLoad, entity);
        }
        catch (Throwable throwable) {
            if (!persister.canWriteToCache()) throw throwable;
            cache.unlockItem(source, ck, lock);
            throw throwable;
        }
        cache.unlockItem(source, ck, lock);
        return event.getSession().getPersistenceContext().proxyFor(persister, keyToLoad, entity);
    }

    private Object doLoad(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) {
        CacheEntityLoaderHelper.PersistenceContextEntry persistenceContextEntry;
        Object entity;
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Attempting to resolve: {0}", (Object)MessageHelper.infoString(persister, event.getEntityId(), event.getSession().getFactory()));
        }
        if ((entity = (persistenceContextEntry = CacheEntityLoaderHelper.INSTANCE.loadFromSessionCache(event, keyToLoad, options)).getEntity()) != null) {
            return persistenceContextEntry.isManaged() ? entity : null;
        }
        entity = CacheEntityLoaderHelper.INSTANCE.loadFromSecondLevelCache(event, persister, keyToLoad);
        if (entity != null) {
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Resolved object in second-level cache: {0}", (Object)MessageHelper.infoString(persister, event.getEntityId(), event.getSession().getFactory()));
            }
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Object not resolved in any cache: {0}", (Object)MessageHelper.infoString(persister, event.getEntityId(), event.getSession().getFactory()));
            }
            entity = this.loadFromDatasource(event, persister);
        }
        if (entity != null && persister.hasNaturalIdentifier()) {
            event.getSession().getPersistenceContext().getNaturalIdHelper().cacheNaturalIdCrossReferenceFromLoad(persister, event.getEntityId(), event.getSession().getPersistenceContext().getNaturalIdHelper().extractNaturalIdValues(entity, persister));
        }
        return entity;
    }

    protected Object loadFromDatasource(LoadEvent event, EntityPersister persister) {
        Object entity = persister.load(event.getEntityId(), event.getInstanceToLoad(), event.getLockOptions(), (SharedSessionContractImplementor)event.getSession());
        if (event.isAssociationFetch() && event.getSession().getFactory().getStatistics().isStatisticsEnabled()) {
            event.getSession().getFactory().getStatistics().fetchEntity(event.getEntityClassName());
        }
        return entity;
    }
}

