/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.collections;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class IdentityMap<K, V>
implements Map<K, V> {
    private final Map<IdentityKey<K>, V> map;
    private transient Map.Entry<IdentityKey<K>, V>[] entryArray = new Map.Entry[0];
    private transient boolean dirty;

    public static <K, V> IdentityMap<K, V> instantiateSequenced(int size2) {
        return new IdentityMap(new LinkedHashMap(size2));
    }

    private IdentityMap(Map<IdentityKey<K>, V> underlyingMap) {
        this.map = underlyingMap;
        this.dirty = true;
    }

    public static <K, V> Map.Entry<K, V>[] concurrentEntries(Map<K, V> map2) {
        return ((IdentityMap)map2).entryArray();
    }

    public Iterator<K> keyIterator() {
        return new KeyIterator(this.map.keySet().iterator());
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(new IdentityKey<Object>(key));
    }

    @Override
    public boolean containsValue(Object val) {
        return this.map.containsValue(val);
    }

    @Override
    public V get(Object key) {
        return this.map.get(new IdentityKey<Object>(key));
    }

    @Override
    public V put(K key, V value) {
        this.dirty = true;
        return this.map.put(new IdentityKey<K>(key), value);
    }

    @Override
    public V remove(Object key) {
        this.dirty = true;
        return this.map.remove(new IdentityKey<Object>(key));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> otherMap) {
        for (Map.Entry<K, V> entry : otherMap.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.dirty = true;
        this.entryArray = null;
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> set = new HashSet<Map.Entry<K, V>>(this.map.size());
        for (Map.Entry<IdentityKey<K>, V> entry : this.map.entrySet()) {
            set.add(new IdentityMapEntry<K, V>(entry.getKey().getRealKey(), entry.getValue()));
        }
        return set;
    }

    public Map.Entry[] entryArray() {
        if (this.dirty) {
            this.entryArray = new Map.Entry[this.map.size()];
            Iterator<Map.Entry<IdentityKey<K>, V>> itr = this.map.entrySet().iterator();
            int i = 0;
            while (itr.hasNext()) {
                Map.Entry<IdentityKey<K>, V> me = itr.next();
                this.entryArray[i++] = new IdentityMapEntry<Object, V>(((IdentityKey)me.getKey()).key, me.getValue());
            }
            this.dirty = false;
        }
        return this.entryArray;
    }

    public String toString() {
        return this.map.toString();
    }

    public static final class IdentityKey<K>
    implements Serializable {
        private final K key;
        private int hash;

        IdentityKey(K key) {
            this.key = key;
        }

        public boolean equals(Object other) {
            return other != null && this.key == ((IdentityKey)other).key;
        }

        public int hashCode() {
            if (this.hash == 0) {
                int newHash = System.identityHashCode(this.key);
                if (newHash == 0) {
                    this.hash = -1;
                    return -1;
                }
                this.hash = newHash;
                return newHash;
            }
            return this.hash;
        }

        public String toString() {
            return this.key.toString();
        }

        public K getRealKey() {
            return this.key;
        }
    }

    public static final class IdentityMapEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        IdentityMapEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V result = this.value;
            this.value = value;
            return result;
        }
    }

    static final class KeyIterator<K>
    implements Iterator<K> {
        private final Iterator<IdentityKey<K>> identityKeyIterator;

        private KeyIterator(Iterator<IdentityKey<K>> iterator2) {
            this.identityKeyIterator = iterator2;
        }

        @Override
        public boolean hasNext() {
            return this.identityKeyIterator.hasNext();
        }

        @Override
        public K next() {
            return this.identityKeyIterator.next().getRealKey();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

