/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.criteria.internal.expression;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.hibernate.query.criteria.internal.CriteriaBuilderImpl;
import org.hibernate.query.criteria.internal.ExpressionImplementor;
import org.hibernate.query.criteria.internal.expression.SelectionImpl;
import org.hibernate.query.criteria.internal.expression.function.CastFunction;

public abstract class ExpressionImpl<T>
extends SelectionImpl<T>
implements ExpressionImplementor<T>,
Serializable {
    public ExpressionImpl(CriteriaBuilderImpl criteriaBuilder, Class<T> javaType) {
        super(criteriaBuilder, javaType);
    }

    @Override
    public <X> Expression<X> as(Class<X> type) {
        return type.equals(this.getJavaType()) ? this : new CastFunction(this.criteriaBuilder(), type, this);
    }

    @Override
    public Predicate isNull() {
        return this.criteriaBuilder().isNull(this);
    }

    @Override
    public Predicate isNotNull() {
        return this.criteriaBuilder().isNotNull(this);
    }

    @Override
    public Predicate in(Object ... values2) {
        return this.criteriaBuilder().in(this, values2);
    }

    @Override
    public Predicate in(Expression<?> ... values2) {
        return this.criteriaBuilder().in(this, (Expression<? extends T>[])values2);
    }

    @Override
    public Predicate in(Collection<?> values2) {
        return this.criteriaBuilder().in(this, values2.toArray());
    }

    @Override
    public Predicate in(Expression<Collection<?>> values2) {
        return this.criteriaBuilder().in(this, new Expression[]{values2});
    }

    @Override
    public ExpressionImplementor<Long> asLong() {
        this.resetJavaType(Long.class);
        return this;
    }

    @Override
    public ExpressionImplementor<Integer> asInteger() {
        this.resetJavaType(Integer.class);
        return this;
    }

    @Override
    public ExpressionImplementor<Float> asFloat() {
        this.resetJavaType(Float.class);
        return this;
    }

    @Override
    public ExpressionImplementor<Double> asDouble() {
        this.resetJavaType(Double.class);
        return this;
    }

    @Override
    public ExpressionImplementor<BigDecimal> asBigDecimal() {
        this.resetJavaType(BigDecimal.class);
        return this;
    }

    @Override
    public ExpressionImplementor<BigInteger> asBigInteger() {
        this.resetJavaType(BigInteger.class);
        return this;
    }

    @Override
    public ExpressionImplementor<String> asString() {
        this.resetJavaType(String.class);
        return this;
    }
}

