/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.job.flow.support.state;

import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.FlowExecutor;
import org.springframework.batch.core.job.flow.support.state.EndState;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.item.ExecutionContext;

public class JsrEndState
extends EndState {
    private JobRepository jobRepository;
    private String restart;

    public JsrEndState(FlowExecutionStatus status, String name) {
        super(status, status.getName(), name);
    }

    public JsrEndState(FlowExecutionStatus status, String code, String name) {
        super(status, code, name, false);
    }

    public JsrEndState(FlowExecutionStatus status, String code, String name, boolean abandon) {
        super(status, code, name, abandon);
    }

    public JsrEndState(FlowExecutionStatus status, String code, String name, String restart, boolean abandon, JobRepository jobRepository) {
        super(status, code, name, abandon);
        this.jobRepository = jobRepository;
        this.restart = restart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlowExecutionStatus handle(FlowExecutor executor) throws Exception {
        FlowExecutor flowExecutor = executor;
        synchronized (flowExecutor) {
            StepExecution stepExecution = executor.getStepExecution();
            if (stepExecution != null && executor.getStepExecution().getStatus() == BatchStatus.UNKNOWN) {
                return FlowExecutionStatus.UNKNOWN;
            }
            if (this.getStatus().isStop()) {
                JobExecution jobExecution = stepExecution.getJobExecution();
                ExecutionContext executionContext = jobExecution.getExecutionContext();
                executionContext.put("batch.restartStep", this.restart);
                executionContext.put("batch.stoppedStep", stepExecution.getStepName());
                this.jobRepository.updateExecutionContext(jobExecution);
                if (!executor.isRestart()) {
                    if (this.isAbandon()) {
                        executor.abandonStepExecution();
                    }
                } else {
                    return FlowExecutionStatus.COMPLETED;
                }
            }
            this.setExitStatus(executor, this.getCode());
            return this.getStatus();
        }
    }

    @Override
    protected void setExitStatus(FlowExecutor executor, String code) {
        StepExecution stepExecution = executor.getStepExecution();
        ExitStatus status = new ExitStatus(code);
        if (!ExitStatus.isNonDefaultExitStatus(status)) {
            stepExecution.getJobExecution().setExitStatus(status);
        }
    }
}

