/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.scope.context;

import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.batch.core.jsr.configuration.support.BatchPropertyContext;

public abstract class SynchronizationManagerSupport<E, C> {
    private final ThreadLocal<Stack<E>> executionHolder = new ThreadLocal();
    private final Map<E, AtomicInteger> counts = new ConcurrentHashMap<E, AtomicInteger>();
    private final Map<E, C> contexts = new ConcurrentHashMap<E, C>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C getContext() {
        if (this.getCurrent().isEmpty()) {
            return null;
        }
        Map<E, C> map2 = this.contexts;
        synchronized (map2) {
            return this.contexts.get(this.getCurrent().peek());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C register(E execution) {
        C context;
        if (execution == null) {
            return null;
        }
        this.getCurrent().push(execution);
        Map<E, C> map2 = this.contexts;
        synchronized (map2) {
            context = this.contexts.get(execution);
            if (context == null) {
                context = this.createNewContext(execution, null);
                this.contexts.put(execution, context);
            }
        }
        this.increment();
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C register(E execution, BatchPropertyContext propertyContext) {
        C context;
        if (execution == null) {
            return null;
        }
        this.getCurrent().push(execution);
        Map<E, C> map2 = this.contexts;
        synchronized (map2) {
            context = this.contexts.get(execution);
            if (context == null) {
                context = this.createNewContext(execution, propertyContext);
                this.contexts.put(execution, context);
            }
        }
        this.increment();
        return context;
    }

    public void close() {
        C oldSession = this.getContext();
        if (oldSession == null) {
            return;
        }
        this.decrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrement() {
        int remaining;
        E current = this.getCurrent().pop();
        if (current != null && (remaining = this.counts.get(current).decrementAndGet()) <= 0) {
            Map<E, C> map2 = this.contexts;
            synchronized (map2) {
                this.contexts.remove(current);
                this.counts.remove(current);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment() {
        E current = this.getCurrent().peek();
        if (current != null) {
            AtomicInteger count2;
            Map<E, AtomicInteger> map2 = this.counts;
            synchronized (map2) {
                count2 = this.counts.get(current);
                if (count2 == null) {
                    count2 = new AtomicInteger();
                    this.counts.put(current, count2);
                }
            }
            count2.incrementAndGet();
        }
    }

    public Stack<E> getCurrent() {
        if (this.executionHolder.get() == null) {
            this.executionHolder.set(new Stack());
        }
        return this.executionHolder.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        C context = this.getContext();
        try {
            if (context != null) {
                this.close(context);
            }
        }
        finally {
            this.close();
        }
    }

    protected abstract void close(C var1);

    protected abstract C createNewContext(E var1, BatchPropertyContext var2);
}

