/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.context.SynchronizedAttributeAccessor;

public class RepeatContextSupport
extends SynchronizedAttributeAccessor
implements RepeatContext {
    private RepeatContext parent;
    private int count;
    private volatile boolean completeOnly;
    private volatile boolean terminateOnly;
    private Map<String, Set<Runnable>> callbacks = new HashMap<String, Set<Runnable>>();

    public RepeatContextSupport(RepeatContext parent) {
        this.parent = parent;
    }

    @Override
    public boolean isCompleteOnly() {
        return this.completeOnly;
    }

    @Override
    public void setCompleteOnly() {
        this.completeOnly = true;
    }

    @Override
    public boolean isTerminateOnly() {
        return this.terminateOnly;
    }

    @Override
    public void setTerminateOnly() {
        this.terminateOnly = true;
        this.setCompleteOnly();
    }

    @Override
    public RepeatContext getParent() {
        return this.parent;
    }

    public synchronized void increment() {
        ++this.count;
    }

    @Override
    public synchronized int getStartedCount() {
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerDestructionCallback(String name, Runnable callback) {
        Map<String, Set<Runnable>> map2 = this.callbacks;
        synchronized (map2) {
            Set<Runnable> set = this.callbacks.get(name);
            if (set == null) {
                set = new HashSet<Runnable>();
                this.callbacks.put(name, set);
            }
            set.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        HashSet<Map.Entry<String, Set<Runnable>>> copy;
        ArrayList<RuntimeException> errors = new ArrayList<RuntimeException>();
        Map<String, Set<Runnable>> map2 = this.callbacks;
        synchronized (map2) {
            copy = new HashSet<Map.Entry<String, Set<Runnable>>>(this.callbacks.entrySet());
        }
        for (Map.Entry entry : copy) {
            for (Runnable callback : (Set)entry.getValue()) {
                if (callback == null) continue;
                try {
                    callback.run();
                }
                catch (RuntimeException t) {
                    errors.add(t);
                }
            }
        }
        if (errors.isEmpty()) {
            return;
        }
        throw (RuntimeException)errors.get(0);
    }
}

