/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.event;

import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.AbstractApplicationEventMulticaster;
import org.springframework.core.ResolvableType;
import org.springframework.util.ErrorHandler;

public class SimpleApplicationEventMulticaster
extends AbstractApplicationEventMulticaster {
    private Executor taskExecutor;
    private ErrorHandler errorHandler;

    public SimpleApplicationEventMulticaster() {
    }

    public SimpleApplicationEventMulticaster(BeanFactory beanFactory) {
        this.setBeanFactory(beanFactory);
    }

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    protected Executor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void multicastEvent(ApplicationEvent event) {
        this.multicastEvent(event, this.resolveDefaultEventType(event));
    }

    @Override
    public void multicastEvent(final ApplicationEvent event, ResolvableType eventType) {
        ResolvableType type = eventType != null ? eventType : this.resolveDefaultEventType(event);
        for (final ApplicationListener<?> listener2 : this.getApplicationListeners(event, type)) {
            Executor executor = this.getTaskExecutor();
            if (executor != null) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        SimpleApplicationEventMulticaster.this.invokeListener(listener2, event);
                    }
                });
                continue;
            }
            this.invokeListener(listener2, event);
        }
    }

    private ResolvableType resolveDefaultEventType(ApplicationEvent event) {
        return ResolvableType.forInstance(event);
    }

    protected void invokeListener(ApplicationListener<?> listener2, ApplicationEvent event) {
        ErrorHandler errorHandler = this.getErrorHandler();
        if (errorHandler != null) {
            try {
                this.doInvokeListener(listener2, event);
            }
            catch (Throwable err) {
                errorHandler.handleError(err);
            }
        } else {
            this.doInvokeListener(listener2, event);
        }
    }

    private void doInvokeListener(ApplicationListener listener2, ApplicationEvent event) {
        try {
            listener2.onApplicationEvent(event);
        }
        catch (ClassCastException ex) {
            String msg = ex.getMessage();
            if (msg == null || this.matchesClassCastMessage(msg, event.getClass())) {
                Log logger2 = LogFactory.getLog(this.getClass());
                if (logger2.isDebugEnabled()) {
                    logger2.debug("Non-matching event type for listener: " + listener2, ex);
                }
            }
            throw ex;
        }
    }

    private boolean matchesClassCastMessage(String classCastMessage, Class<?> eventClass) {
        if (classCastMessage.startsWith(eventClass.getName())) {
            return true;
        }
        if (classCastMessage.startsWith(eventClass.toString())) {
            return true;
        }
        int moduleSeparatorIndex = classCastMessage.indexOf(47);
        return moduleSeparatorIndex != -1 && classCastMessage.startsWith(eventClass.getName(), moduleSeparatorIndex + 1);
    }
}

